/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.webstart;

import java.lang.reflect.Method;
import java.net.URL;

public final class JNLPProxy {
    private static final Object basicServiceObject = JNLPProxy.getBasicServiceObject();
    private static final Class basicServiceClass = JNLPProxy.getBasicServiceClass();

    public static void main(String[] args) throws Exception {
        JNLPProxy.showDocument(new URL(args[0]));
    }

    public static boolean showDocument(URL url) {
        if (basicServiceObject == null) {
            System.out.println("basisServiceObject = null");
            return false;
        }
        try {
            Method method = basicServiceClass.getMethod("showDocument", URL.class);
            Boolean resultBoolean = (Boolean)method.invoke(basicServiceObject, url);
            boolean success = resultBoolean;
            if (!success) {
                System.out.println("invocation of method failed!");
            }
            return success;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    private static Object getBasicServiceObject() {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            return lookupMethod.invoke(null, "javax.jnlp.BasicService");
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Class getBasicServiceClass() {
        try {
            return Class.forName("javax.jnlp.BasicService");
        }
        catch (Exception ex) {
            return null;
        }
    }

    private JNLPProxy() {
    }
}

