/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.alignment.template.AlignedSequence;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.io.CasePreservingProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderParser;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.util.SequenceTools;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.biojava.nbio.structure.align.xml.AFPChainXMLConverter;
import org.biojava.nbio.structure.io.StructureSequenceMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastaAFPChainConverter {
    private static final Logger logger = LoggerFactory.getLogger(FastaAFPChainConverter.class);

    public static AFPChain cpFastaToAfpChain(String first, String second, Structure structure, int cpSite) throws StructureException, CompoundNotFoundException {
        ProteinSequence s1 = new ProteinSequence(first);
        s1.setUserCollection(FastaAFPChainConverter.getAlignedUserCollection(first));
        ProteinSequence s2 = new ProteinSequence(second);
        s2.setUserCollection(FastaAFPChainConverter.getAlignedUserCollection(second));
        return FastaAFPChainConverter.cpFastaToAfpChain(s1, s2, structure, cpSite);
    }

    public static AFPChain cpFastaToAfpChain(File fastaFile, Structure structure, int cpSite) throws IOException, StructureException {
        FileInputStream inStream = new FileInputStream(fastaFile);
        CasePreservingProteinSequenceCreator creator = new CasePreservingProteinSequenceCreator((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet());
        GenericFastaHeaderParser headerParser = new GenericFastaHeaderParser();
        FastaReader fastaReader = new FastaReader((InputStream)inStream, (SequenceHeaderParserInterface)headerParser, (SequenceCreatorInterface)creator);
        LinkedHashMap sequences = fastaReader.process();
        ((InputStream)inStream).close();
        Iterator iter = sequences.values().iterator();
        ProteinSequence first = (ProteinSequence)iter.next();
        ProteinSequence second = (ProteinSequence)iter.next();
        return FastaAFPChainConverter.cpFastaToAfpChain(first, second, structure, cpSite);
    }

    public static AFPChain cpFastaToAfpChain(ProteinSequence first, ProteinSequence second, Structure structure, int cpSite) throws StructureException {
        if (structure == null) {
            throw new IllegalArgumentException("The structure is null");
        }
        if (first == null) {
            throw new IllegalArgumentException("The sequence is null");
        }
        int gappedCpShift = 0;
        int ungappedCpShift = 0;
        while (ungappedCpShift < Math.abs(cpSite)) {
            char c;
            try {
                c = cpSite <= 0 ? second.getSequenceAsString().charAt(gappedCpShift) : second.getSequenceAsString().charAt(first.getLength() - 1 - gappedCpShift);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("CP site of " + cpSite + " is wrong");
            }
            if (c != '-') {
                ++ungappedCpShift;
            }
            ++gappedCpShift;
        }
        Atom[] ca1 = StructureTools.getRepresentativeAtomArray(structure);
        Atom[] ca2 = StructureTools.getRepresentativeAtomArray(structure);
        ProteinSequence antipermuted = null;
        try {
            antipermuted = new ProteinSequence(SequenceTools.permuteCyclic((String)second.getSequenceAsString(), (int)gappedCpShift));
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error while creating protein sequence: {}. This is most likely a bug.", (Object)e.getMessage());
        }
        Object[] residues = StructureSequenceMatcher.matchSequenceToStructure(first, structure);
        Object[] antipermutedResidues = StructureSequenceMatcher.matchSequenceToStructure(antipermuted, structure);
        Object[] nonpermutedResidues = new ResidueNumber[antipermutedResidues.length];
        SequenceTools.permuteCyclic((Object[])antipermutedResidues, (Object[])nonpermutedResidues, (int)(-gappedCpShift));
        if (first.getUserCollection() != null) {
            CasePreservingProteinSequenceCreator.setLowercaseToNull((ProteinSequence)first, (Object[])residues);
        }
        if (second.getUserCollection() != null) {
            CasePreservingProteinSequenceCreator.setLowercaseToNull((ProteinSequence)second, (Object[])nonpermutedResidues);
        }
        return FastaAFPChainConverter.buildAlignment(ca1, ca2, (ResidueNumber[])residues, (ResidueNumber[])nonpermutedResidues);
    }

    public static AFPChain fastaFileToAfpChain(File fastaFile, Structure structure1, Structure structure2) throws IOException, StructureException {
        FileInputStream inStream = new FileInputStream(fastaFile);
        CasePreservingProteinSequenceCreator creator = new CasePreservingProteinSequenceCreator((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet());
        GenericFastaHeaderParser headerParser = new GenericFastaHeaderParser();
        FastaReader fastaReader = new FastaReader((InputStream)inStream, (SequenceHeaderParserInterface)headerParser, (SequenceCreatorInterface)creator);
        LinkedHashMap sequences = fastaReader.process();
        ((InputStream)inStream).close();
        return FastaAFPChainConverter.fastaToAfpChain(sequences, structure1, structure2);
    }

    public static AFPChain fastaStringToAfpChain(String sequence1, String sequence2, Structure structure1, Structure structure2) throws StructureException, CompoundNotFoundException {
        ProteinSequence seq1 = new ProteinSequence(sequence1);
        ProteinSequence seq2 = new ProteinSequence(sequence2);
        return FastaAFPChainConverter.fastaToAfpChain(seq1, seq2, structure1, structure2);
    }

    public static AFPChain fastaToAfpChain(Map<String, ProteinSequence> sequences, Structure structure1, Structure structure2) throws StructureException {
        if (sequences.size() != 2) {
            throw new IllegalArgumentException("There must be exactly 2 sequences, but there were " + sequences.size());
        }
        if (structure1 == null || structure2 == null) {
            throw new IllegalArgumentException("A structure is null");
        }
        ArrayList<ProteinSequence> seqs = new ArrayList<ProteinSequence>();
        ArrayList<String> names = new ArrayList<String>(2);
        for (Map.Entry<String, ProteinSequence> entry : sequences.entrySet()) {
            seqs.add(entry.getValue());
            names.add(entry.getKey());
        }
        return FastaAFPChainConverter.fastaToAfpChain((ProteinSequence)seqs.get(0), (ProteinSequence)seqs.get(1), structure1, structure2);
    }

    public static AFPChain fastaToAfpChain(String sequence1, String sequence2, Structure structure1, Structure structure2) throws StructureException, CompoundNotFoundException {
        ProteinSequence s1 = new ProteinSequence(sequence1);
        s1.setUserCollection(FastaAFPChainConverter.getAlignedUserCollection(sequence1));
        ProteinSequence s2 = new ProteinSequence(sequence2);
        s2.setUserCollection(FastaAFPChainConverter.getAlignedUserCollection(sequence2));
        return FastaAFPChainConverter.fastaToAfpChain(s1, s2, structure1, structure2);
    }

    public static AFPChain fastaToAfpChain(ProteinSequence sequence1, ProteinSequence sequence2, Structure structure1, Structure structure2) throws StructureException {
        if (structure1 == null || structure2 == null) {
            throw new IllegalArgumentException("A structure is null");
        }
        if (sequence1 == null || sequence2 == null) {
            throw new IllegalArgumentException("A sequence is null");
        }
        Atom[] ca1 = StructureTools.getRepresentativeAtomArray(structure1);
        Atom[] ca2 = StructureTools.getRepresentativeAtomArray(structure2);
        Object[] residues1 = StructureSequenceMatcher.matchSequenceToStructure(sequence1, structure1);
        Object[] residues2 = StructureSequenceMatcher.matchSequenceToStructure(sequence2, structure2);
        if (sequence1.getUserCollection() != null) {
            CasePreservingProteinSequenceCreator.setLowercaseToNull((ProteinSequence)sequence1, (Object[])residues1);
        }
        if (sequence2.getUserCollection() != null) {
            CasePreservingProteinSequenceCreator.setLowercaseToNull((ProteinSequence)sequence2, (Object[])residues2);
        }
        return FastaAFPChainConverter.buildAlignment(ca1, ca2, (ResidueNumber[])residues1, (ResidueNumber[])residues2);
    }

    public static AFPChain fastaToAfpChain(SequencePair<Sequence<AminoAcidCompound>, AminoAcidCompound> alignment, Structure structure1, Structure structure2) throws StructureException {
        List seqs = alignment.getAlignedSequences();
        StringBuilder sb1 = new StringBuilder();
        for (AminoAcidCompound a : (AlignedSequence)seqs.get(0)) {
            sb1.append(a.getBase());
        }
        try {
            ProteinSequence seq1 = new ProteinSequence(sb1.toString());
            StringBuilder sb2 = new StringBuilder();
            for (AminoAcidCompound a : (AlignedSequence)seqs.get(1)) {
                sb1.append(a.getBase());
            }
            ProteinSequence seq2 = new ProteinSequence(sb2.toString());
            LinkedHashMap<String, ProteinSequence> map = new LinkedHashMap<String, ProteinSequence>();
            map.put(structure1.getName(), seq1);
            map.put(structure2.getName(), seq2);
            return FastaAFPChainConverter.fastaToAfpChain(map, structure1, structure2);
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error while creating protein sequences: {}. This is most likely a bug.", (Object)e.getMessage());
            return null;
        }
    }

    private static AFPChain buildAlignment(Atom[] ca1, Atom[] ca2, ResidueNumber[] residues1, ResidueNumber[] residues2) throws StructureException {
        ArrayList<ResidueNumber> alignedResiduesList1 = new ArrayList<ResidueNumber>();
        ArrayList<ResidueNumber> alignedResiduesList2 = new ArrayList<ResidueNumber>();
        for (int i = 0; i < residues1.length; ++i) {
            if (residues1[i] == null || residues2[i] == null) continue;
            alignedResiduesList1.add(residues1[i]);
            alignedResiduesList2.add(residues2[i]);
        }
        ResidueNumber[] alignedResidues1 = alignedResiduesList1.toArray(new ResidueNumber[alignedResiduesList1.size()]);
        ResidueNumber[] alignedResidues2 = alignedResiduesList2.toArray(new ResidueNumber[alignedResiduesList2.size()]);
        AFPChain afpChain = AlignmentTools.createAFPChain(ca1, ca2, alignedResidues1, alignedResidues2);
        afpChain.setAlgorithmName("unknown");
        AlignmentTools.updateSuperposition(afpChain, ca1, ca2);
        afpChain.setBlockSize(new int[]{afpChain.getNrEQR()});
        afpChain.setBlockRmsd(new double[]{afpChain.getTotalRmsdOpt()});
        afpChain.setBlockGap(new int[]{afpChain.getGapLen()});
        return afpChain;
    }

    public static List<Object> getAlignedUserCollection(String sequence) {
        ArrayList<Object> aligned = new ArrayList<Object>(sequence.length());
        for (char c : sequence.toCharArray()) {
            aligned.add(Character.isUpperCase(c));
        }
        return aligned;
    }

    public static void main(String[] args) throws StructureException, IOException {
        if (args.length != 3) {
            System.err.println("Usage: FastaAFPChainConverter fasta-file structure-1-name structure-2-name");
            return;
        }
        File fasta = new File(args[0]);
        Structure structure1 = StructureTools.getStructure(args[1]);
        Structure structure2 = StructureTools.getStructure(args[2]);
        if (structure1 == null) {
            throw new IllegalArgumentException("No structure for " + args[1] + " was found");
        }
        if (structure2 == null) {
            throw new IllegalArgumentException("No structure for " + args[2] + " was found");
        }
        AFPChain afpChain = FastaAFPChainConverter.fastaFileToAfpChain(fasta, structure1, structure2);
        String xml = AFPChainXMLConverter.toXML(afpChain);
        System.out.println(xml);
    }
}

