/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox.annotations;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.codeartisans.java.toolbox.annotations.PublicNoArgConstructor"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class PublicNoArgConstructorProcessor
extends AbstractProcessor {
    private static final TypeVisitor<Boolean, Void> NO_ARGS_VISITOR = new SimpleTypeVisitor6<Boolean, Void>(){

        @Override
        public Boolean visitExecutable(ExecutableType t, Void v) {
            return t.getParameterTypes().isEmpty();
        }
    };

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        for (TypeElement typeElement : annotations) {
            this.processNoArgsConstructorClasses(env, typeElement);
        }
        return true;
    }

    private void processNoArgsConstructorClasses(RoundEnvironment env, TypeElement type) {
        for (Element element : env.getElementsAnnotatedWith(type)) {
            this.processClass(element);
        }
    }

    private void processClass(Element element) {
        if (!this.doesClassContainNoArgsConstructor(element)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Class " + element + " needs a Public No-Args Constructor");
        }
    }

    private boolean doesClassContainNoArgsConstructor(Element el) {
        for (Element element : el.getEnclosedElements()) {
            TypeMirror mirror;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !(mirror = element.asType()).accept(NO_ARGS_VISITOR, null).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

