/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="NonEmptyCaseWithoutBreak", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class NonEmptyCaseWithoutBreakCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).caseClause, ((EcmaScriptGrammar)this.getContext().getGrammar()).defaultClause});
    }

    public void visitNode(AstNode astNode) {
        EcmaScriptGrammar grammar = (EcmaScriptGrammar)this.getContext().getGrammar();
        AstNode statementList = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statementList});
        if (statementList != null && statementList.getLastChild().getFirstChild().isNot(new AstNodeType[]{grammar.breakStatement, grammar.returnStatement, grammar.throwStatement})) {
            this.getContext().createLineViolation((CodeCheck)this, "Last statement in this switch-clause should be an unconditional break.", astNode, new Object[0]);
        }
    }
}

