/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1125", name="Literal boolean values should not be used in condition expressions", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BooleanEqualityComparisonCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo((AstNodeType[])CheckUtils.equalityExpressionArray());
        this.subscribeTo(new AstNodeType[]{Tree.Kind.LOGICAL_COMPLEMENT});
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR});
    }

    public void visitNode(AstNode astNode) {
        AstNode boolLiteral = BooleanEqualityComparisonCheck.getBooleanLiteralFromExpresion(astNode);
        if (boolLiteral != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the literal \"" + boolLiteral.getTokenOriginalValue() + "\" boolean value.", boolLiteral, new Object[0]);
        }
    }

    private static AstNode getBooleanLiteralFromExpresion(AstNode expression) {
        if (expression.is(new AstNodeType[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            return BooleanEqualityComparisonCheck.getBooleanLiteralFromUnaryExpression(expression);
        }
        BinaryExpressionTree binaryExpr = (BinaryExpressionTree)expression;
        if (expression.getParent().is((AstNodeType[])CheckUtils.equalityExpressionArray())) {
            return null;
        }
        AstNode leftExpr = (AstNode)binaryExpr.leftOperand();
        AstNode rightExpr = (AstNode)binaryExpr.rightOperand();
        if (BooleanEqualityComparisonCheck.isBooleanLiteral(leftExpr)) {
            return leftExpr;
        }
        if (BooleanEqualityComparisonCheck.isBooleanLiteral(rightExpr)) {
            return rightExpr;
        }
        return null;
    }

    private static AstNode getBooleanLiteralFromUnaryExpression(AstNode unaryExpression) {
        AstNode expr;
        AstNode boolLiteral = null;
        if (unaryExpression.getFirstChild().is(new AstNodeType[]{EcmaScriptPunctuator.BANG}) && BooleanEqualityComparisonCheck.isBooleanLiteral(expr = unaryExpression.getLastChild())) {
            boolLiteral = expr;
        }
        return boolLiteral;
    }

    public static boolean isBooleanLiteral(AstNode node) {
        return EcmaScriptKeyword.FALSE.getValue().equals(node.getTokenValue()) || EcmaScriptKeyword.TRUE.getValue().equals(node.getTokenValue());
    }
}

