/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.implementations.statement.IfStatementTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="CollapsibleIfStatements", name="Collapsible \"if\" statements should be merged", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class CollapsibleIfStatementsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.IF_STATEMENT});
    }

    public void visitNode(AstNode node) {
        StatementTree innerStatement;
        IfStatementTreeImpl ifStatement = (IfStatementTreeImpl)node;
        if (!ifStatement.hasElse() && (this.isBlockAndContainsOnlyOneIfStatement((AstNode)(innerStatement = ifStatement.thenStatement())) || this.isIfStatementWithoutElse(innerStatement))) {
            this.getContext().createLineViolation((CodeCheck)this, "Merge this if statement with the nested one.", node, new Object[0]);
        }
    }

    private boolean isBlockAndContainsOnlyOneIfStatement(AstNode statement) {
        if (!statement.is(new AstNodeType[]{Tree.Kind.BLOCK})) {
            return false;
        }
        BlockTree block = (BlockTree)statement;
        return block.statements().size() == 1 ? this.isIfStatementWithoutElse((StatementTree)block.statements().get(0)) : false;
    }

    private boolean isIfStatementWithoutElse(StatementTree statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && !((IfStatementTreeImpl)statement).hasElse();
    }
}

