/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.ElseClauseTree;
import org.sonar.javascript.model.interfaces.statement.IfStatementTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;
import org.sonar.javascript.model.interfaces.statement.SwitchClauseTree;
import org.sonar.javascript.model.interfaces.statement.SwitchStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1871", name="Two branches in the same conditional structure should not have exactly the same implementation", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class DuplicateBranchImplementationCheck
extends BaseTreeVisitor {
    public void visitIfStatement(IfStatementTree tree) {
        StatementTree implementation = tree.thenStatement();
        ElseClauseTree elseClause = tree.elseClause();
        while (elseClause != null) {
            StatementTree implementationToCompare = DuplicateBranchImplementationCheck.getImplementationFromElseClause(elseClause);
            if (SyntacticEquivalence.areEquivalent((Tree)implementation, (Tree)implementationToCompare)) {
                this.getContext().addIssue((CodeVisitor)this, (Tree)implementationToCompare, "Either merge this branch with the identical one on line \"" + ((AstNode)implementation).getTokenLine() + "\" or change one of the implementations.");
                break;
            }
            elseClause = this.getNextElse(elseClause);
        }
        super.visitIfStatement(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        for (int i = 0; i < tree.cases().size(); ++i) {
            SwitchClauseTree caseTree = (SwitchClauseTree)tree.cases().get(i);
            if (caseTree.statements().isEmpty() || this.isCaseEndingWithoutJumpStmt(caseTree)) continue;
            this.compareWithNextCases(tree, i, caseTree);
        }
    }

    private void compareWithNextCases(SwitchStatementTree tree, int indexCaseReference, SwitchClauseTree caseTree) {
        for (int j = indexCaseReference + 1; j < tree.cases().size(); ++j) {
            List caseStatements;
            SwitchClauseTree caseTreeToCompare = (SwitchClauseTree)tree.cases().get(j);
            if (caseTreeToCompare.statements().isEmpty() || this.isCaseEndingWithoutJumpStmt(caseTreeToCompare)) continue;
            List list = caseStatements = caseTreeToCompare.is(new Tree.Kind[]{Tree.Kind.DEFAULT_CLAUSE}) ? caseTree.statements().subList(0, caseTree.statements().size() - 1) : caseTree.statements();
            if (!SyntacticEquivalence.areEquivalent((List)caseStatements, (List)caseTreeToCompare.statements())) continue;
            this.getContext().addIssue((CodeVisitor)this, (Tree)caseTreeToCompare, "Either merge this case with the identical one on line \"" + ((AstNode)caseTree).getTokenLine() + "\" or change one of the implementations.");
            break;
        }
    }

    private boolean isCaseEndingWithoutJumpStmt(SwitchClauseTree caseTree) {
        return caseTree.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE}) && !this.isJumpStatement((StatementTree)Iterables.getLast((Iterable)caseTree.statements()));
    }

    private boolean isJumpStatement(StatementTree statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.THROW_STATEMENT});
    }

    private static StatementTree getImplementationFromElseClause(ElseClauseTree elseClause) {
        return elseClause.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) ? ((IfStatementTree)elseClause.statement()).thenStatement() : elseClause.statement();
    }

    public ElseClauseTree getNextElse(ElseClauseTree elseClause) {
        return elseClause.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) ? ((IfStatementTree)elseClause.statement()).elseClause() : null;
    }
}

