/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2424", name="Built-in objects should not be overridden", priority=Priority.CRITICAL, tags={"bug", "confusing"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class BuildInObjectOverriddenCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this override of \"%s\".";
    private static final List<String> BUILD_IN_OBJECTS = ImmutableList.of((Object)"Object", (Object)"Function", (Object)"Boolean", (Object)"Symbol", (Object)"Error", (Object)"EvalError", (Object)"InternalError", (Object)"RangeError", (Object)"ReferenceError", (Object)"SyntaxError", (Object)"TypeError", (Object)"URIError", (Object[])new String[]{"Number", "Math", "Date", "String", "RegExp", "Array", "Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Unit16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array", "Map", "Set", "WeakMap", "WeakSet", "ArrayBuffer", "DataView", "JSON", "Promise", "Reflect", "Proxy", "Intl", "Generator", "Iterator", "ParallelArray", "StopIteration"});

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(BUILD_IN_OBJECTS);
        for (Symbol symbol : symbols) {
            this.getContext().addIssue((CodeVisitor)this, symbol.getFirstDeclaration().tree(), String.format(MESSAGE, symbol.name()));
        }
    }
}

