/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.ForStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1264", name="A \"while\" loop should be used instead of a \"for\" loop", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class ForHidingWhileCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FOR_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        if (!ForHidingWhileCheck.hasInitialisation(astNode) && !ForHidingWhileCheck.hasIncrement(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this \"for\" loop with a \"while\" loop", astNode, new Object[0]);
        }
    }

    public static boolean hasInitialisation(AstNode forStmt) {
        return forStmt.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.LPARENTHESIS}).getNextAstNode().isNot(new AstNodeType[]{EcmaScriptPunctuator.SEMI});
    }

    public static boolean hasIncrement(AstNode forStmt) {
        return ((ForStatementTree)forStmt).update() != null;
    }
}

