/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.DotMemberExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.LiteralTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2692", name="\"indexOf\" checks should not be for positive numbers", priority=Priority.MAJOR, tags={"bug"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class IndexOfCompareToPositiveNumberCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.GREATER_THAN);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree expression = (BinaryExpressionTree)tree;
        if (IndexOfCompareToPositiveNumberCheck.isZero(expression.rightOperand()) && IndexOfCompareToPositiveNumberCheck.isIndexOfCall(expression.leftOperand())) {
            this.addIssue(tree, "0 is a valid index, but is ignored by this check.");
        }
    }

    private static boolean isIndexOfCall(ExpressionTree expression) {
        CallExpressionTree callExpr;
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION}) && (callExpr = (CallExpressionTree)expression).arguments().parameters().size() == 1 && callExpr.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree memberExpr = (DotMemberExpressionTree)((CallExpressionTree)expression).callee();
            return IndexOfCompareToPositiveNumberCheck.isExpressionIdentifierNamed(memberExpr.property(), "indexOf");
        }
        return false;
    }

    private static boolean isExpressionIdentifierNamed(ExpressionTree tree, String name) {
        return tree instanceof IdentifierTree && name.equals(((IdentifierTree)tree).name());
    }

    private static boolean isZero(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "0".equals(((LiteralTree)expression).value());
    }
}

