/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;
import org.sonar.javascript.model.interfaces.statement.SwitchClauseTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="NonEmptyCaseWithoutBreak", name="Switch cases should end with an unconditional \"break\" statement", priority=Priority.CRITICAL, tags={"cert", "cwe", "misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NonEmptyCaseWithoutBreakCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE});
    }

    public void visitNode(AstNode astNode) {
        SwitchClauseTree block;
        if (astNode.getNextAstNode().is(new AstNodeType[]{Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE}) && !(block = (SwitchClauseTree)astNode).statements().isEmpty() && !((StatementTree)Iterables.getLast((Iterable)block.statements())).is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT})) {
            this.getContext().createLineViolation((CodeCheck)this, "Last statement in this switch-clause should be an unconditional break.", astNode, new Object[0]);
        }
    }
}

