/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="UnusedVariable", name="Unused local variables should be removed", priority=Priority.MAJOR, tags={"unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedVariableCheck
extends BaseTreeVisitor {
    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (Symbol variable : symbolModel.getSymbols(new Symbol.Kind[]{Symbol.Kind.VARIABLE})) {
            Collection usages = symbolModel.getUsageFor(variable);
            if (!this.noUsages(usages) || this.isGlobalOrCatchVariable(symbolModel, variable) || variable.buildIn()) continue;
            this.getContext().addIssue((CodeVisitor)this, variable.getFirstDeclaration().tree(), "Remove the declaration of the unused '" + variable.name() + "' variable.");
        }
    }

    private boolean noUsages(Collection<Usage> usages) {
        return usages.isEmpty() || this.usagesAreInitializations(usages);
    }

    private boolean usagesAreInitializations(Collection<Usage> usages) {
        for (Usage usage : usages) {
            if (usage.isInit()) continue;
            return false;
        }
        return true;
    }

    private boolean isGlobalOrCatchVariable(SymbolModel symbolModel, Symbol symbol) {
        return symbolModel.getScopeFor(symbol).getTree().is(new Tree.Kind[]{Tree.Kind.SCRIPT, Tree.Kind.CATCH_BLOCK});
    }
}

