/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum EcmaScriptGrammar implements GrammarRuleKey
{
    EOF,
    EOS,
    EOS_NO_LB,
    IDENTIFIER_NAME,
    CONDITION,
    LITERAL,
    NULL_LITERAL,
    BOOLEAN_LITERAL,
    STRING_LITERAL,
    KEYWORD,
    LETTER_OR_DIGIT,
    SPACING,
    SPACING_NO_LB,
    NEXT_NOT_LB,
    LINE_TERMINATOR_SEQUENCE,
    PRIMARY_EXPRESSION,
    ARRAY_LITERAL,
    OBJECT_LITERAL,
    PROPERTY_ASSIGNMENT,
    PROPERTY_NAME,
    PROPERTY_SET_PARAMETER_LIST,
    MEMBER_EXPRESSION,
    NEW_EXPRESSION,
    CALL_EXPRESSION,
    ARGUMENTS,
    LEFT_HAND_SIDE_EXPRESSION,
    POSTFIX_EXPRESSION,
    UNARY_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    ADDITIVE_EXPRESSION,
    SHIFT_EXPRESSION,
    RELATIONAL_EXPRESSION,
    RELATIONAL_EXPRESSION_NO_IN,
    EQUALITY_EXPRESSION,
    EQUALITY_EXPRESSION_NO_IN,
    BITWISE_AND_EXPRESSION,
    BITWISE_AND_EXPRESSION_NO_IN,
    BITWISE_XOR_EXPRESSION,
    BITWISE_XOR_EXPRESSION_NO_IN,
    BITWISE_OR_EXPRESSION,
    BITWISE_OR_EXPRESSION_NO_IN,
    LOGICAL_AND_EXPRESSION,
    LOGICAL_AND_EXPRESSION_NO_IN,
    LOGICAL_OR_EXPRESSION,
    LOGICAL_OR_EXPRESSION_NO_IN,
    CONDITIONAL_EXPRESSION,
    CONDITIONAL_EXPRESSION_NO_IN,
    ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_EXPRESSION_NO_IN,
    ASSIGNMENT_OPERATOR,
    EXPRESSION,
    EXPRESSION_NO_IN,
    STATEMENT,
    BLOCK,
    STATEMENT_LIST,
    VARIABLE_STATEMENT,
    VARIABLE_DECLARATION_LIST,
    VARIABLE_DECLARATION_LIST_NO_IN,
    VARIABLE_DECLARATION,
    VARIABLE_DECLARATION_NO_IN,
    INITIALISER,
    INITIALISER_NO_IN,
    EMPTY_STATEMENT,
    EXPRESSION_STATEMENT,
    IF_STATEMENT,
    ELSE_CLAUSE,
    ITERATION_STATEMENT,
    DO_WHILE_STATEMENT,
    WHILE_STATEMENT,
    FOR_IN_STATEMENT,
    FOR_STATEMENT,
    CONTINUE_STATEMENT,
    BREAK_STATEMENT,
    RETURN_STATEMENT,
    WITH_STATEMENT,
    SWITCH_STATEMENT,
    CASE_BLOCK,
    CASE_CLAUSES,
    CASE_CLAUSE,
    DEFAULT_CLAUSE,
    LABELLED_STATEMENT,
    THROW_STATEMENT,
    TRY_STATEMENT,
    CATCH,
    FINALLY,
    DEBUGGER_STATEMENT,
    FUNCTION_DECLARATION,
    FUNCTION_EXPRESSION,
    FORMAL_PARAMETER_LIST,
    FUNCTION_BODY,
    PROGRAM,
    SOURCE_ELEMENTS,
    SOURCE_ELEMENT,
    SHEBANG;

    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return EcmaScriptGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule((GrammarRuleKey)IDENTIFIER_NAME).is((Object)SPACING, new Object[]{b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        b.rule((GrammarRuleKey)LITERAL).is(b.firstOf((Object)NULL_LITERAL, (Object)BOOLEAN_LITERAL, new Object[]{EcmaScriptTokenType.NUMERIC_LITERAL, STRING_LITERAL, EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL}));
        b.rule((GrammarRuleKey)NULL_LITERAL).is((Object)EcmaScriptKeyword.NULL);
        b.rule((GrammarRuleKey)BOOLEAN_LITERAL).is(b.firstOf((Object)EcmaScriptKeyword.TRUE, (Object)EcmaScriptKeyword.FALSE));
        EcmaScriptGrammar.lexical(b);
        EcmaScriptGrammar.expressions(b);
        EcmaScriptGrammar.statements(b);
        EcmaScriptGrammar.functionsAndPrograms(b);
        b.setRootRule((GrammarRuleKey)PROGRAM);
        return b;
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), new Object[]{b.zeroOrMore(b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), new Object[]{b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"))})}).skip();
        b.rule((GrammarRuleKey)SPACING_NO_LB).is(b.zeroOrMore(b.firstOf(b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")), b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)"))))).skip();
        b.rule((GrammarRuleKey)NEXT_NOT_LB).is(b.nextNot(b.regexp("(?:/\\*[\\s\\S]*?\\*/|[\\n\\r\\u2028\\u2029])"))).skip();
        b.rule((GrammarRuleKey)LINE_TERMINATOR_SEQUENCE).is(b.skippedTrivia(b.regexp("(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)"))).skip();
        b.rule((GrammarRuleKey)EOS).is(b.firstOf(b.sequence((Object)SPACING, (Object)EcmaScriptPunctuator.SEMI), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOS_NO_LB).is(b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EcmaScriptPunctuator.SEMI}), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING_NO_LB, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOF).is(b.token((TokenType)GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule((GrammarRuleKey)EcmaScriptTokenType.IDENTIFIER).is((Object)SPACING, new Object[]{b.nextNot((Object)KEYWORD), b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        b.rule((GrammarRuleKey)EcmaScriptTokenType.NUMERIC_LITERAL).is((Object)SPACING, new Object[]{b.regexp("(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)")});
        b.rule((GrammarRuleKey)STRING_LITERAL).is((Object)SPACING, new Object[]{b.token((TokenType)GenericTokenType.LITERAL, b.regexp("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')"))});
        b.rule((GrammarRuleKey)EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL).is((Object)SPACING, new Object[]{b.regexp("\\/(?![*/])(?:[^\\\\\\[/&&[^\\r\\n\\u2028\\u2029]]|\\[(?:[^\\]\\\\&&[^\\r\\n\\u2028\\u2029]]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+")});
        EcmaScriptGrammar.punctuators(b);
        EcmaScriptGrammar.keywords(b);
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LCURLYBRACE, "{");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RCURLYBRACE, "}");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LPARENTHESIS, "(");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RPARENTHESIS, ")");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LBRACKET, "[");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RBRACKET, "]");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOT, ".");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SEMI, ";");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COMMA, ",");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LT, "<", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GT, ">", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LE, "<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GE, ">=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL, "==", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL, "!=", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL2, "===");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL2, "!==");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS, "+", b.nextNot(b.firstOf((Object)"+", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS, "-", b.nextNot(b.firstOf((Object)"-", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR, "*", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD, "%", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV, "/", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.INC, "++");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DEC, "--");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL, "<<", b.nextNot(b.firstOf((Object)"<", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR, ">>", b.nextNot(b.firstOf((Object)">", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR2, ">>>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND, "&", b.nextNot((Object)"&", new Object[]{"="}));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR, "|", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR, "^", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.BANG, "!", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.TILDA, "~");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ANDAND, "&&");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OROR, "||");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.QUERY, "?");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COLON, ":");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQU, "=", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS_EQU, "+=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS_EQU, "-=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV_EQU, "/=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR_EQU, "*=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD_EQU, "%=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL_EQU, "<<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU, ">>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU2, ">>>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND_EQU, "&=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR_EQU, "|=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR_EQU, "^=");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)LETTER_OR_DIGIT).is(b.regexp("\\p{javaJavaIdentifierPart}"));
        Object[] rest = new Object[EcmaScriptKeyword.values().length - 2];
        for (int i = 0; i < EcmaScriptKeyword.values().length; ++i) {
            EcmaScriptKeyword tokenType = EcmaScriptKeyword.values()[i];
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{tokenType.getValue(), b.nextNot((Object)LETTER_OR_DIGIT)});
            if (i <= 1) continue;
            rest[i - 2] = tokenType.getValue();
        }
        b.rule((GrammarRuleKey)KEYWORD).is(b.firstOf((Object)EcmaScriptKeyword.keywordValues()[0], (Object)EcmaScriptKeyword.keywordValues()[1], rest), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value});
            return;
        }
        throw new IllegalStateException(value);
    }

    private static Object word(LexerlessGrammarBuilder b, String value) {
        return b.sequence((Object)SPACING, b.token((TokenType)GenericTokenType.IDENTIFIER, (Object)value));
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value, element});
            return;
        }
        throw new IllegalStateException(value);
    }

    private static void expressions(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)PRIMARY_EXPRESSION).is(b.firstOf((Object)EcmaScriptKeyword.THIS, (Object)EcmaScriptTokenType.IDENTIFIER, new Object[]{LITERAL, ARRAY_LITERAL, OBJECT_LITERAL, b.sequence((Object)EcmaScriptPunctuator.LPARENTHESIS, (Object)EXPRESSION, new Object[]{EcmaScriptPunctuator.RPARENTHESIS})}));
        b.rule((GrammarRuleKey)ARRAY_LITERAL).is((Object)EcmaScriptPunctuator.LBRACKET, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.COMMA, (Object)ASSIGNMENT_EXPRESSION)), EcmaScriptPunctuator.RBRACKET});
        b.rule((GrammarRuleKey)OBJECT_LITERAL).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)PROPERTY_ASSIGNMENT, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{PROPERTY_ASSIGNMENT}), b.optional((Object)EcmaScriptPunctuator.COMMA)}), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)PROPERTY_ASSIGNMENT).is(b.firstOf(b.sequence((Object)PROPERTY_NAME, (Object)EcmaScriptPunctuator.COLON, new Object[]{ASSIGNMENT_EXPRESSION}), b.sequence(EcmaScriptGrammar.word(b, "get"), (Object)PROPERTY_NAME, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE}), new Object[]{b.sequence(EcmaScriptGrammar.word(b, "set"), (Object)PROPERTY_NAME, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, PROPERTY_SET_PARAMETER_LIST, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE})}));
        b.rule((GrammarRuleKey)PROPERTY_NAME).is(b.firstOf((Object)IDENTIFIER_NAME, (Object)STRING_LITERAL, new Object[]{EcmaScriptTokenType.NUMERIC_LITERAL}));
        b.rule((GrammarRuleKey)PROPERTY_SET_PARAMETER_LIST).is((Object)EcmaScriptTokenType.IDENTIFIER);
        b.rule((GrammarRuleKey)MEMBER_EXPRESSION).is(b.firstOf((Object)PRIMARY_EXPRESSION, (Object)FUNCTION_EXPRESSION, new Object[]{b.sequence((Object)EcmaScriptKeyword.NEW, (Object)MEMBER_EXPRESSION, new Object[]{ARGUMENTS})}), new Object[]{b.zeroOrMore(b.firstOf(b.sequence((Object)EcmaScriptPunctuator.LBRACKET, (Object)EXPRESSION, new Object[]{EcmaScriptPunctuator.RBRACKET}), b.sequence((Object)EcmaScriptPunctuator.DOT, (Object)IDENTIFIER_NAME)))});
        b.rule((GrammarRuleKey)NEW_EXPRESSION).is(b.firstOf((Object)MEMBER_EXPRESSION, b.sequence((Object)EcmaScriptKeyword.NEW, (Object)NEW_EXPRESSION)));
        b.rule((GrammarRuleKey)CALL_EXPRESSION).is(b.sequence((Object)MEMBER_EXPRESSION, (Object)ARGUMENTS), new Object[]{b.zeroOrMore(b.firstOf((Object)ARGUMENTS, b.sequence((Object)EcmaScriptPunctuator.LBRACKET, (Object)EXPRESSION, new Object[]{EcmaScriptPunctuator.RBRACKET}), new Object[]{b.sequence((Object)EcmaScriptPunctuator.DOT, (Object)IDENTIFIER_NAME)}))});
        b.rule((GrammarRuleKey)ARGUMENTS).is((Object)EcmaScriptPunctuator.LPARENTHESIS, new Object[]{b.optional((Object)ASSIGNMENT_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{ASSIGNMENT_EXPRESSION})}), EcmaScriptPunctuator.RPARENTHESIS});
        b.rule((GrammarRuleKey)LEFT_HAND_SIDE_EXPRESSION).is(b.firstOf((Object)CALL_EXPRESSION, (Object)NEW_EXPRESSION));
        b.rule((GrammarRuleKey)POSTFIX_EXPRESSION).is((Object)LEFT_HAND_SIDE_EXPRESSION, new Object[]{b.optional((Object)SPACING_NO_LB, new Object[]{NEXT_NOT_LB, b.firstOf((Object)EcmaScriptPunctuator.INC, (Object)EcmaScriptPunctuator.DEC)})});
        b.rule((GrammarRuleKey)UNARY_EXPRESSION).is(b.firstOf((Object)POSTFIX_EXPRESSION, b.sequence((Object)EcmaScriptKeyword.DELETE, (Object)UNARY_EXPRESSION), new Object[]{b.sequence((Object)EcmaScriptKeyword.VOID, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptKeyword.TYPEOF, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.INC, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.DEC, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.PLUS, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.MINUS, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.TILDA, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.BANG, (Object)UNARY_EXPRESSION)}));
        b.rule((GrammarRuleKey)MULTIPLICATIVE_EXPRESSION).is((Object)UNARY_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.STAR, (Object)EcmaScriptPunctuator.DIV, new Object[]{EcmaScriptPunctuator.MOD}), new Object[]{UNARY_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)ADDITIVE_EXPRESSION).is((Object)MULTIPLICATIVE_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.PLUS, (Object)EcmaScriptPunctuator.MINUS), new Object[]{MULTIPLICATIVE_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)SHIFT_EXPRESSION).is((Object)ADDITIVE_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.SL, (Object)EcmaScriptPunctuator.SR, new Object[]{EcmaScriptPunctuator.SR2}), new Object[]{ADDITIVE_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)RELATIONAL_EXPRESSION).is((Object)SHIFT_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.LT, (Object)EcmaScriptPunctuator.GT, new Object[]{EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF, EcmaScriptKeyword.IN}), new Object[]{SHIFT_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)RELATIONAL_EXPRESSION_NO_IN).is((Object)SHIFT_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.LT, (Object)EcmaScriptPunctuator.GT, new Object[]{EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF}), new Object[]{SHIFT_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)EQUALITY_EXPRESSION).is((Object)RELATIONAL_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.EQUAL, (Object)EcmaScriptPunctuator.NOTEQUAL, new Object[]{EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2}), new Object[]{RELATIONAL_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)EQUALITY_EXPRESSION_NO_IN).is((Object)RELATIONAL_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.EQUAL, (Object)EcmaScriptPunctuator.NOTEQUAL, new Object[]{EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2}), new Object[]{RELATIONAL_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_AND_EXPRESSION).is((Object)EQUALITY_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.AND, new Object[]{EQUALITY_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_AND_EXPRESSION_NO_IN).is((Object)EQUALITY_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.AND, new Object[]{EQUALITY_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_XOR_EXPRESSION).is((Object)BITWISE_AND_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.XOR, new Object[]{BITWISE_AND_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_XOR_EXPRESSION_NO_IN).is((Object)BITWISE_AND_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.XOR, new Object[]{BITWISE_AND_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_OR_EXPRESSION).is((Object)BITWISE_XOR_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OR, new Object[]{BITWISE_XOR_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_OR_EXPRESSION_NO_IN).is((Object)BITWISE_XOR_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OR, new Object[]{BITWISE_XOR_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_AND_EXPRESSION).is((Object)BITWISE_OR_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.ANDAND, new Object[]{BITWISE_OR_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_AND_EXPRESSION_NO_IN).is((Object)BITWISE_OR_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.ANDAND, new Object[]{BITWISE_OR_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_OR_EXPRESSION).is((Object)LOGICAL_AND_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OROR, new Object[]{LOGICAL_AND_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_OR_EXPRESSION_NO_IN).is((Object)LOGICAL_AND_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OROR, new Object[]{LOGICAL_AND_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)CONDITIONAL_EXPRESSION).is((Object)LOGICAL_OR_EXPRESSION, new Object[]{b.optional((Object)EcmaScriptPunctuator.QUERY, new Object[]{ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)CONDITIONAL_EXPRESSION_NO_IN).is((Object)LOGICAL_OR_EXPRESSION_NO_IN, new Object[]{b.optional((Object)EcmaScriptPunctuator.QUERY, new Object[]{ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)ASSIGNMENT_EXPRESSION).is(b.firstOf(b.sequence((Object)LEFT_HAND_SIDE_EXPRESSION, (Object)ASSIGNMENT_OPERATOR, new Object[]{ASSIGNMENT_EXPRESSION}), (Object)CONDITIONAL_EXPRESSION)).skipIfOneChild();
        b.rule((GrammarRuleKey)ASSIGNMENT_EXPRESSION_NO_IN).is(b.firstOf(b.sequence((Object)LEFT_HAND_SIDE_EXPRESSION, (Object)ASSIGNMENT_OPERATOR, new Object[]{ASSIGNMENT_EXPRESSION_NO_IN}), (Object)CONDITIONAL_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule((GrammarRuleKey)ASSIGNMENT_OPERATOR).is(b.firstOf((Object)EcmaScriptPunctuator.EQU, (Object)EcmaScriptPunctuator.STAR_EQU, new Object[]{EcmaScriptPunctuator.DIV_EQU, EcmaScriptPunctuator.MOD_EQU, EcmaScriptPunctuator.PLUS_EQU, EcmaScriptPunctuator.MINUS_EQU, EcmaScriptPunctuator.SL_EQU, EcmaScriptPunctuator.SR_EQU, EcmaScriptPunctuator.SR_EQU2, EcmaScriptPunctuator.AND_EQU, EcmaScriptPunctuator.XOR_EQU, EcmaScriptPunctuator.OR_EQU})).skip();
        b.rule((GrammarRuleKey)EXPRESSION).is((Object)ASSIGNMENT_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{ASSIGNMENT_EXPRESSION})});
        b.rule((GrammarRuleKey)EXPRESSION_NO_IN).is((Object)ASSIGNMENT_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{ASSIGNMENT_EXPRESSION_NO_IN})});
    }

    private static void statements(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)STATEMENT).is(b.firstOf((Object)BLOCK, (Object)VARIABLE_STATEMENT, new Object[]{EMPTY_STATEMENT, LABELLED_STATEMENT, EXPRESSION_STATEMENT, IF_STATEMENT, ITERATION_STATEMENT, CONTINUE_STATEMENT, BREAK_STATEMENT, RETURN_STATEMENT, WITH_STATEMENT, SWITCH_STATEMENT, THROW_STATEMENT, TRY_STATEMENT, DEBUGGER_STATEMENT}));
        b.rule((GrammarRuleKey)BLOCK).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)STATEMENT_LIST), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)STATEMENT_LIST).is(b.oneOrMore(b.firstOf((Object)STATEMENT, EcmaScriptGrammar.permissive((Object)FUNCTION_DECLARATION))));
        b.rule((GrammarRuleKey)VARIABLE_STATEMENT).is((Object)EcmaScriptKeyword.VAR, new Object[]{VARIABLE_DECLARATION_LIST, EOS});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION_LIST).is((Object)VARIABLE_DECLARATION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{VARIABLE_DECLARATION})});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION_LIST_NO_IN).is((Object)VARIABLE_DECLARATION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{VARIABLE_DECLARATION_NO_IN})});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION).is((Object)EcmaScriptTokenType.IDENTIFIER, new Object[]{b.optional((Object)INITIALISER)});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION_NO_IN).is((Object)EcmaScriptTokenType.IDENTIFIER, new Object[]{b.optional((Object)INITIALISER_NO_IN)});
        b.rule((GrammarRuleKey)INITIALISER).is((Object)EcmaScriptPunctuator.EQU, new Object[]{ASSIGNMENT_EXPRESSION});
        b.rule((GrammarRuleKey)INITIALISER_NO_IN).is((Object)EcmaScriptPunctuator.EQU, new Object[]{ASSIGNMENT_EXPRESSION_NO_IN});
        b.rule((GrammarRuleKey)EMPTY_STATEMENT).is((Object)EcmaScriptPunctuator.SEMI);
        b.rule((GrammarRuleKey)EXPRESSION_STATEMENT).is(b.nextNot(b.firstOf((Object)EcmaScriptPunctuator.LCURLYBRACE, (Object)EcmaScriptKeyword.FUNCTION)), new Object[]{EXPRESSION, EOS});
        b.rule((GrammarRuleKey)CONDITION).is((Object)EXPRESSION);
        b.rule((GrammarRuleKey)IF_STATEMENT).is((Object)EcmaScriptKeyword.IF, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT, b.optional((Object)ELSE_CLAUSE)});
        b.rule((GrammarRuleKey)ELSE_CLAUSE).is((Object)EcmaScriptKeyword.ELSE, new Object[]{STATEMENT});
        b.rule((GrammarRuleKey)ITERATION_STATEMENT).is(b.firstOf((Object)DO_WHILE_STATEMENT, (Object)WHILE_STATEMENT, new Object[]{FOR_IN_STATEMENT, FOR_STATEMENT}));
        b.rule((GrammarRuleKey)DO_WHILE_STATEMENT).is((Object)EcmaScriptKeyword.DO, new Object[]{STATEMENT, EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, EOS});
        b.rule((GrammarRuleKey)WHILE_STATEMENT).is((Object)EcmaScriptKeyword.WHILE, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)FOR_IN_STATEMENT).is((Object)EcmaScriptKeyword.FOR, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence((Object)EcmaScriptKeyword.VAR, (Object)VARIABLE_DECLARATION_LIST_NO_IN), (Object)LEFT_HAND_SIDE_EXPRESSION), EcmaScriptKeyword.IN, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)FOR_STATEMENT).is((Object)EcmaScriptKeyword.FOR, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence((Object)EcmaScriptKeyword.VAR, (Object)VARIABLE_DECLARATION_LIST_NO_IN), b.optional((Object)EXPRESSION_NO_IN)), EcmaScriptPunctuator.SEMI, b.optional((Object)CONDITION), EcmaScriptPunctuator.SEMI, b.optional((Object)EXPRESSION), EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)CONTINUE_STATEMENT).is((Object)EcmaScriptKeyword.CONTINUE, new Object[]{b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EcmaScriptTokenType.IDENTIFIER, EOS}), (Object)EOS_NO_LB)});
        b.rule((GrammarRuleKey)BREAK_STATEMENT).is((Object)EcmaScriptKeyword.BREAK, new Object[]{b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EcmaScriptTokenType.IDENTIFIER, EOS}), (Object)EOS_NO_LB)});
        b.rule((GrammarRuleKey)RETURN_STATEMENT).is((Object)EcmaScriptKeyword.RETURN, new Object[]{b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EXPRESSION, EOS}), (Object)EOS_NO_LB)});
        b.rule((GrammarRuleKey)WITH_STATEMENT).is((Object)EcmaScriptKeyword.WITH, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)SWITCH_STATEMENT).is((Object)EcmaScriptKeyword.SWITCH, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, CASE_BLOCK});
        b.rule((GrammarRuleKey)CASE_BLOCK).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)CASE_CLAUSES), b.optional((Object)DEFAULT_CLAUSE, new Object[]{b.optional((Object)CASE_CLAUSES)}), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)CASE_CLAUSES).is(b.oneOrMore((Object)CASE_CLAUSE));
        b.rule((GrammarRuleKey)CASE_CLAUSE).is((Object)EcmaScriptKeyword.CASE, new Object[]{EXPRESSION, EcmaScriptPunctuator.COLON, b.optional((Object)STATEMENT_LIST)});
        b.rule((GrammarRuleKey)DEFAULT_CLAUSE).is((Object)EcmaScriptKeyword.DEFAULT, new Object[]{EcmaScriptPunctuator.COLON, b.optional((Object)STATEMENT_LIST)});
        b.rule((GrammarRuleKey)LABELLED_STATEMENT).is((Object)EcmaScriptTokenType.IDENTIFIER, new Object[]{EcmaScriptPunctuator.COLON, STATEMENT});
        b.rule((GrammarRuleKey)THROW_STATEMENT).is((Object)EcmaScriptKeyword.THROW, new Object[]{SPACING_NO_LB, NEXT_NOT_LB, EXPRESSION, EOS});
        b.rule((GrammarRuleKey)TRY_STATEMENT).is((Object)EcmaScriptKeyword.TRY, new Object[]{BLOCK, b.firstOf(b.sequence((Object)CATCH, b.optional((Object)FINALLY)), (Object)FINALLY)});
        b.rule((GrammarRuleKey)CATCH).is((Object)EcmaScriptKeyword.CATCH, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.RPARENTHESIS, BLOCK});
        b.rule((GrammarRuleKey)FINALLY).is((Object)EcmaScriptKeyword.FINALLY, new Object[]{BLOCK});
        b.rule((GrammarRuleKey)DEBUGGER_STATEMENT).is((Object)EcmaScriptKeyword.DEBUGGER, new Object[]{EOS});
    }

    private static void functionsAndPrograms(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)FUNCTION_DECLARATION).is((Object)EcmaScriptKeyword.FUNCTION, new Object[]{EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)FUNCTION_EXPRESSION).is((Object)EcmaScriptKeyword.FUNCTION, new Object[]{b.optional((Object)EcmaScriptTokenType.IDENTIFIER), EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)FORMAL_PARAMETER_LIST).is((Object)EcmaScriptTokenType.IDENTIFIER, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{EcmaScriptTokenType.IDENTIFIER})});
        b.rule((GrammarRuleKey)FUNCTION_BODY).is(b.optional((Object)SOURCE_ELEMENTS));
        b.rule((GrammarRuleKey)PROGRAM).is(b.optional((Object)SHEBANG), new Object[]{b.optional((Object)SOURCE_ELEMENTS), SPACING, EOF});
        b.rule((GrammarRuleKey)SOURCE_ELEMENTS).is(b.oneOrMore((Object)SOURCE_ELEMENT));
        b.rule((GrammarRuleKey)SOURCE_ELEMENT).is(b.firstOf((Object)STATEMENT, (Object)FUNCTION_DECLARATION));
        b.rule((GrammarRuleKey)SHEBANG).is((Object)"#!", new Object[]{b.regexp("[^\\n\\r]*+")}).skip();
    }

    private static Object permissive(Object object) {
        return object;
    }

    private EcmaScriptGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

