/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import java.io.File;
import java.util.Collection;
import org.sonar.javascript.CharsetAwareVisitor;
import org.sonar.javascript.EcmaScriptCommentAnalyser;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.ProgressAstScanner;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.javascript.parser.EcmaScriptParser;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.CommentAnalyser;
import org.sonar.squidbridge.SourceCodeBuilderCallback;
import org.sonar.squidbridge.SourceCodeBuilderVisitor;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.squidbridge.metrics.CommentsVisitor;
import org.sonar.squidbridge.metrics.CounterVisitor;
import org.sonar.squidbridge.metrics.LinesOfCodeVisitor;
import org.sonar.squidbridge.metrics.LinesVisitor;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

public final class JavaScriptAstScanner {
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.METHOD, EcmaScriptGrammar.GENERATOR_METHOD, EcmaScriptGrammar.GENERATOR_EXPRESSION, EcmaScriptGrammar.GENERATOR_DECLARATION};

    private JavaScriptAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<LexerlessGrammar> scanner = JavaScriptAstScanner.create(new EcmaScriptConfiguration(Charsets.UTF_8), visitors);
        scanner.scanFile(file);
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<LexerlessGrammar> create(EcmaScriptConfiguration conf, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("JavaScript Project"));
        Parser<LexerlessGrammar> parser = EcmaScriptParser.create(conf, new ParsingEventListener[0]);
        AstScanner.Builder builder = new ProgressAstScanner.Builder((SquidAstVisitorContextImpl<LexerlessGrammar>)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])EcmaScriptMetric.values());
        builder.setCommentAnalyser((CommentAnalyser)new EcmaScriptCommentAnalyser());
        builder.setFilesMetric((MetricDef)EcmaScriptMetric.FILES);
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){
            private int seq = 0;

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                ++this.seq;
                SourceClass cls = new SourceClass("class:" + this.seq);
                cls.setStartAtLine(astNode.getTokenLine());
                return cls;
            }
        }, new AstNodeType[]{EcmaScriptGrammar.CLASS_DECLARATION}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.CLASSES).subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CLASS_DECLARATION}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.FUNCTIONS).subscribeTo((AstNodeType[])FUNCTION_NODES).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                AstNode identifier = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER, EcmaScriptGrammar.PROPERTY_NAME, EcmaScriptGrammar.BINDING_IDENTIFIER});
                String functionName = identifier == null ? "anonymous" : identifier.getTokenValue();
                String fileKey = parentSourceCode.isType(SourceFile.class) ? parentSourceCode.getKey() : ((SourceFile)parentSourceCode.getParent(SourceFile.class)).getKey();
                SourceFunction function = new SourceFunction(fileKey + ":" + functionName + ":" + astNode.getToken().getLine() + ":" + astNode.getToken().getColumn());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, (AstNodeType[])FUNCTION_NODES));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)EcmaScriptMetric.LINES));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesOfCodeVisitor((MetricDef)EcmaScriptMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)EcmaScriptMetric.COMMENT_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.STATEMENTS).subscribeTo(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_STATEMENT, EcmaScriptGrammar.EMPTY_STATEMENT, EcmaScriptGrammar.EXPRESSION_STATEMENT, EcmaScriptGrammar.IF_STATEMENT, EcmaScriptGrammar.ITERATION_STATEMENT, EcmaScriptGrammar.CONTINUE_STATEMENT, EcmaScriptGrammar.BREAK_STATEMENT, EcmaScriptGrammar.RETURN_STATEMENT, EcmaScriptGrammar.WITH_STATEMENT, EcmaScriptGrammar.SWITCH_STATEMENT, EcmaScriptGrammar.THROW_STATEMENT, EcmaScriptGrammar.TRY_STATEMENT, EcmaScriptGrammar.DEBUGGER_STATEMENT}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.ACCESSORS).subscribeTo(new AstNodeType[]{EcmaScriptGrammar.GETTER_METHOD, EcmaScriptGrammar.SETTER_METHOD}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new ComplexityVisitor());
        for (SquidAstVisitor<LexerlessGrammar> visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)visitor).setCharset(conf.getCharset());
            }
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

