/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jstestdriver;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.javascript.core.JavaScript;
import org.sonar.plugins.javascript.coverage.JavaScriptFileCoverage;
import org.sonar.plugins.javascript.coverage.LCOVParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverCoverageSensor
implements Sensor {
    protected JavaScript javascript;
    private static final Logger LOG = LoggerFactory.getLogger(JsTestDriverCoverageSensor.class);

    public JsTestDriverCoverageSensor(JavaScript javascript) {
        this.javascript = javascript;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.javascript.equals(project.getLanguage()) && "jstestdriver".equals(this.javascript.getSettings().getString("sonar.javascript.testframework"));
    }

    public void analyse(Project project, SensorContext sensorContext) {
        File jsTestDriverCoverageReportFile = new File(project.getFileSystem().getBasedir(), this.getTestReportsFolder() + "/" + this.getTestCoverageFileName());
        LCOVParser parser = new LCOVParser();
        List<JavaScriptFileCoverage> coveredFiles = parser.parseFile(jsTestDriverCoverageReportFile);
        this.analyseCoveredFiles(project, sensorContext, coveredFiles);
    }

    protected void analyseCoveredFiles(Project project, SensorContext sensorContext, List<JavaScriptFileCoverage> coveredFiles) {
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"js"})) {
            try {
                JavaScriptFileCoverage fileCoverage = this.getFileCoverage(inputFile, coveredFiles);
                org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)inputFile.getFile(), (Project)project);
                PropertiesBuilder lineHitsData = new PropertiesBuilder(CoreMetrics.COVERAGE_LINE_HITS_DATA);
                if (fileCoverage != null) {
                    Map<Integer, Integer> hits = fileCoverage.getLineCoverageData();
                    for (Map.Entry<Integer, Integer> entry : hits.entrySet()) {
                        lineHitsData.add((Object)entry.getKey(), (Object)entry.getValue());
                    }
                    sensorContext.saveMeasure((Resource)resource, lineHitsData.build());
                    sensorContext.saveMeasure((Resource)resource, CoreMetrics.LINES_TO_COVER, Double.valueOf(fileCoverage.getLinesToCover()));
                    sensorContext.saveMeasure((Resource)resource, CoreMetrics.UNCOVERED_LINES, Double.valueOf(fileCoverage.getUncoveredLines()));
                    continue;
                }
                for (int x = 1; x < sensorContext.getMeasure((Resource)resource, CoreMetrics.LINES).getIntValue(); ++x) {
                    lineHitsData.add((Object)x, (Object)0);
                }
                Measure ncloc = sensorContext.getMeasure((Resource)resource, CoreMetrics.NCLOC);
                sensorContext.saveMeasure((Resource)resource, lineHitsData.build());
                sensorContext.saveMeasure((Resource)resource, CoreMetrics.LINES_TO_COVER, ncloc.getValue());
                sensorContext.saveMeasure((Resource)resource, CoreMetrics.UNCOVERED_LINES, ncloc.getValue());
            }
            catch (Exception e) {
                LOG.error("Problem while calculating coverage for " + inputFile.getFileBaseDir() + inputFile.getRelativePath(), (Throwable)e);
            }
        }
    }

    protected JavaScriptFileCoverage getFileCoverage(InputFile input, List<JavaScriptFileCoverage> coverages) {
        for (JavaScriptFileCoverage file : coverages) {
            if (!file.getFilePath().equals(input.getFile().getAbsolutePath()) && !file.getFilePath().equals(input.getRelativePath())) continue;
            return file;
        }
        return null;
    }

    protected String getTestReportsFolder() {
        return this.javascript.getSettings().getString("sonar.javascript.jstestdriver.reportsfolder");
    }

    protected String getTestCoverageFileName() {
        return this.javascript.getSettings().getString("sonar.javascript.jstestdriver.coveragefile");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

