/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.unittest.surefireparser;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.javascript.unittest.surefireparser.UnitTestResult;

public class UnitTestClassReport {
    private long errors = 0L;
    private long failures = 0L;
    private long skipped = 0L;
    private long tests = 0L;
    private long durationMilliseconds = 0L;
    private List<UnitTestResult> results = null;

    public UnitTestClassReport add(UnitTestClassReport other) {
        for (UnitTestResult otherResult : other.getResults()) {
            this.add(otherResult);
        }
        return this;
    }

    public UnitTestClassReport add(UnitTestResult result) {
        this.initResults();
        this.results.add(result);
        if (result.getStatus().equals("skipped")) {
            ++this.skipped;
        } else if (result.getStatus().equals("failure")) {
            ++this.failures;
        } else if (result.getStatus().equals("error")) {
            ++this.errors;
        }
        ++this.tests;
        this.durationMilliseconds += result.getDurationMilliseconds();
        return this;
    }

    private void initResults() {
        if (this.results == null) {
            this.results = Lists.newArrayList();
        }
    }

    public long getErrors() {
        return this.errors;
    }

    public long getFailures() {
        return this.failures;
    }

    public long getSkipped() {
        return this.skipped;
    }

    public long getTests() {
        return this.tests;
    }

    public long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    public List<UnitTestResult> getResults() {
        if (this.results == null) {
            return Collections.emptyList();
        }
        return this.results;
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<tests-details>");
        for (UnitTestResult result : this.results) {
            result.appendXml(sb);
        }
        sb.append("</tests-details>");
        return sb.toString();
    }
}

