/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="FunctionComplexity", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionComplexityCheck
extends SquidCheck<Grammar> {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void leaveNode(AstNode node) {
        SourceFunction function = (SourceFunction)this.getContext().peekSourceCode();
        if (function.getInt((MetricDef)PythonMetric.COMPLEXITY) > this.maximumFunctionComplexityThreshold) {
            this.getContext().createLineViolation((CodeCheck)this, "Function has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", node, new Object[]{function.getInt((MetricDef)PythonMetric.COMPLEXITY), this.maximumFunctionComplexityThreshold});
        }
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

