/*
 * Decompiled with CFR 0.152.
 */
package fj.data.optic;

import fj.F;
import fj.Function;
import fj.Monoid;
import fj.P;
import fj.P2;
import fj.data.Either;
import fj.data.optic.Fold;
import fj.data.optic.PIso;
import fj.data.optic.PLens;
import fj.data.optic.POptional;
import fj.data.optic.PPrism;

public abstract class Getter<S, A> {
    Getter() {
    }

    public abstract A get(S var1);

    public final <S1> Getter<Either<S, S1>, A> sum(Getter<S1, A> other) {
        return Getter.getter(e -> e.either(this::get, other::get));
    }

    public final <S1, A1> Getter<P2<S, S1>, P2<A, A1>> product(Getter<S1, A1> other) {
        return Getter.getter(p2 -> P.p(this.get(p2._1()), other.get(p2._2())));
    }

    public final <B> Getter<P2<S, B>, P2<A, B>> first() {
        return Getter.getter(p -> P.p(this.get(p._1()), p._2()));
    }

    public final <B> Getter<P2<B, S>, P2<B, A>> second() {
        return Getter.getter(p -> P.p(p._1(), this.get(p._2())));
    }

    public final <B> Fold<S, B> composeFold(Fold<A, B> other) {
        return this.asFold().composeFold(other);
    }

    public final <B> Getter<S, B> composeGetter(Getter<A, B> other) {
        return Getter.getter(s -> other.get(this.get(s)));
    }

    public final <B, C, D> Fold<S, C> composeOptional(POptional<A, B, C, D> other) {
        return this.asFold().composeOptional(other);
    }

    public final <B, C, D> Fold<S, C> composePrism(PPrism<A, B, C, D> other) {
        return this.asFold().composePrism(other);
    }

    public final <B, C, D> Getter<S, C> composeLens(PLens<A, B, C, D> other) {
        return this.composeGetter(other.asGetter());
    }

    public final <B, C, D> Getter<S, C> composeIso(PIso<A, B, C, D> other) {
        return this.composeGetter(other.asGetter());
    }

    public final Fold<S, A> asFold() {
        return new Fold<S, A>(){

            @Override
            public <B> F<S, B> foldMap(Monoid<B> m, F<A, B> f) {
                return s -> f.f(Getter.this.get(s));
            }
        };
    }

    public static <A> Getter<A, A> id() {
        return PIso.pId().asGetter();
    }

    public static <A> Getter<Either<A, A>, A> codiagonal() {
        return Getter.getter(e -> e.either(Function.identity(), Function.identity()));
    }

    public static <S, A> Getter<S, A> getter(final F<S, A> get) {
        return new Getter<S, A>(){

            @Override
            public A get(S s) {
                return get.f(s);
            }
        };
    }
}

