/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.util.Iterator;
import org.atp.api.Typeable;
import org.sql.generation.api.grammar.modification.ColumnSourceByQuery;
import org.sql.generation.api.grammar.modification.ColumnSourceByValues;
import org.sql.generation.api.grammar.modification.DeleteBySearch;
import org.sql.generation.api.grammar.modification.DynamicColumnSource;
import org.sql.generation.api.grammar.modification.InsertStatement;
import org.sql.generation.api.grammar.modification.SetClause;
import org.sql.generation.api.grammar.modification.TargetTable;
import org.sql.generation.api.grammar.modification.UpdateBySearch;
import org.sql.generation.api.grammar.modification.UpdateSourceByExpression;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.QueryProcessing;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class ModificationProcessing {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateSourceByExpressionProcessor
    extends AbstractProcessor<UpdateSourceByExpression> {
        public UpdateSourceByExpressionProcessor() {
            this((Class<? extends UpdateSourceByExpression>)UpdateSourceByExpression.class);
        }

        public UpdateSourceByExpressionProcessor(Class<? extends UpdateSourceByExpression> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, UpdateSourceByExpression object, StringBuilder builder) {
            processor.process((Typeable<?>)object.getValueExpression(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateBySearchProcessor
    extends AbstractProcessor<UpdateBySearch> {
        public UpdateBySearchProcessor() {
            this((Class<? extends UpdateBySearch>)UpdateBySearch.class);
        }

        protected UpdateBySearchProcessor(Class<? extends UpdateBySearch> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, UpdateBySearch object, StringBuilder builder) {
            builder.append("UPDATE").append(" ");
            processor.process((Typeable<?>)object.getTargetTable(), builder);
            builder.append("\n").append("SET").append(" ");
            Iterator iter = object.getSetClauses().iterator();
            while (iter.hasNext()) {
                processor.process((Typeable)iter.next(), builder);
                if (!iter.hasNext()) continue;
                builder.append(",").append(" ");
            }
            QueryProcessing.processOptionalBooleanExpression(processor, builder, object.getWhere(), "\n", "WHERE");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TargetTableProcessor
    extends AbstractProcessor<TargetTable> {
        public TargetTableProcessor() {
            this((Class<? extends TargetTable>)TargetTable.class);
        }

        protected TargetTableProcessor(Class<? extends TargetTable> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, TargetTable object, StringBuilder builder) {
            Boolean isOnly = object.isOnly();
            if (isOnly.booleanValue()) {
                builder.append("ONLY").append("(");
            }
            processor.process((Typeable<?>)object.getTableName(), builder);
            if (isOnly.booleanValue()) {
                builder.append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetClauseProcessor
    extends AbstractProcessor<SetClause> {
        public SetClauseProcessor() {
            this((Class<? extends SetClause>)SetClause.class);
        }

        public SetClauseProcessor(Class<? extends SetClause> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, SetClause object, StringBuilder builder) {
            builder.append(object.getUpdateTarget()).append(" ").append("=").append(" ");
            processor.process((Typeable<?>)object.getUpdateSource(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InsertStatementProcessor
    extends AbstractProcessor<InsertStatement> {
        public InsertStatementProcessor() {
            this((Class<? extends InsertStatement>)InsertStatement.class);
        }

        public InsertStatementProcessor(Class<? extends InsertStatement> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, InsertStatement object, StringBuilder builder) {
            builder.append("INSERT INTO").append(" ");
            processor.process((Typeable<?>)object.getTableName(), builder);
            builder.append(" ");
            processor.process((Typeable<?>)object.getColumnSource(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteBySearchProcessor
    extends AbstractProcessor<DeleteBySearch> {
        public DeleteBySearchProcessor() {
            this((Class<? extends DeleteBySearch>)DeleteBySearch.class);
        }

        public DeleteBySearchProcessor(Class<? extends DeleteBySearch> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, DeleteBySearch object, StringBuilder builder) {
            builder.append("DELETE FROM").append(" ");
            processor.process((Typeable<?>)object.getTargetTable(), builder);
            QueryProcessing.processOptionalBooleanExpression(processor, builder, object.getWhere(), "\n", "WHERE");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnSourceByValuesProcessor
    extends DynamicColumnSourceProcessor<ColumnSourceByValues> {
        public ColumnSourceByValuesProcessor() {
            this((Class<? extends ColumnSourceByValues>)ColumnSourceByValues.class);
        }

        public ColumnSourceByValuesProcessor(Class<? extends ColumnSourceByValues> realType) {
            super(realType);
        }

        @Override
        protected void doProcessColumnSource(SQLProcessorAggregator processor, ColumnSourceByValues object, StringBuilder builder) {
            builder.append("\n").append("VALUES").append("(");
            Iterator iter = object.getValues().iterator();
            while (iter.hasNext()) {
                processor.process((Typeable)iter.next(), builder);
                if (!iter.hasNext()) continue;
                builder.append(",").append(" ");
            }
            builder.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnSourceByQueryProcessor
    extends DynamicColumnSourceProcessor<ColumnSourceByQuery> {
        public ColumnSourceByQueryProcessor() {
            this((Class<? extends ColumnSourceByQuery>)ColumnSourceByQuery.class);
        }

        protected ColumnSourceByQueryProcessor(Class<? extends ColumnSourceByQuery> realType) {
            super(realType);
        }

        @Override
        protected void doProcessColumnSource(SQLProcessorAggregator processor, ColumnSourceByQuery object, StringBuilder builder) {
            builder.append("\n");
            processor.process((Typeable<?>)object.getQuery(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DynamicColumnSourceProcessor<SourceType extends DynamicColumnSource>
    extends AbstractProcessor<SourceType> {
        public DynamicColumnSourceProcessor(Class<? extends SourceType> realType) {
            super(realType);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator processor, SourceType object, StringBuilder builder) {
            if (object.getColumnNames() != null) {
                builder.append("(");
                processor.process((Typeable<?>)object.getColumnNames(), builder);
                builder.append(")");
            }
            this.doProcessColumnSource(processor, object, builder);
        }

        protected abstract void doProcessColumnSource(SQLProcessorAggregator var1, SourceType var2, StringBuilder var3);
    }
}

