/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.util.HashMap;
import java.util.Map;
import org.sql.generation.api.grammar.common.datatypes.Decimal;
import org.sql.generation.api.grammar.common.datatypes.IntervalDataType;
import org.sql.generation.api.grammar.common.datatypes.Numeric;
import org.sql.generation.api.grammar.common.datatypes.SQLChar;
import org.sql.generation.api.grammar.common.datatypes.SQLFloat;
import org.sql.generation.api.grammar.common.datatypes.SQLInterval;
import org.sql.generation.api.grammar.common.datatypes.SQLTime;
import org.sql.generation.api.grammar.common.datatypes.SQLTimeStamp;
import org.sql.generation.api.grammar.common.datatypes.UserDefinedType;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class DataTypeProcessing {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLTimeStampProcessor
    extends AbstractProcessor<SQLTimeStamp> {
        public SQLTimeStampProcessor() {
            super(SQLTimeStamp.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SQLTimeStamp object, StringBuilder builder) {
            builder.append("TIMESTAMP");
            if (object.getPrecision() != null) {
                builder.append("(").append(object.getPrecision()).append(")");
            }
            if (object.isWithTimeZone() != null) {
                builder.append(" ").append("WITH");
                if (!object.isWithTimeZone().booleanValue()) {
                    builder.append("OUT");
                }
                builder.append(" ").append("TIME ZONE");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLTimeProcessor
    extends AbstractProcessor<SQLTime> {
        public SQLTimeProcessor() {
            super(SQLTime.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SQLTime object, StringBuilder builder) {
            builder.append("TIME");
            if (object.getPrecision() != null) {
                builder.append("(").append(object.getPrecision()).append(")");
            }
            if (object.isWithTimeZone() != null) {
                builder.append(" ").append("WITH");
                if (!object.isWithTimeZone().booleanValue()) {
                    builder.append("OUT");
                }
                builder.append(" ").append("TIME ZONE");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLIntervalProcessor
    extends AbstractProcessor<SQLInterval> {
        private static final Map<IntervalDataType, String> _defaultIntervalDataTypes;
        private final Map<IntervalDataType, String> _intervalDataTypes;

        public SQLIntervalProcessor() {
            this(_defaultIntervalDataTypes);
        }

        public SQLIntervalProcessor(Map<IntervalDataType, String> intervalDataTypes) {
            super(SQLInterval.class);
            this._intervalDataTypes = intervalDataTypes;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SQLInterval object, StringBuilder builder) {
            builder.append("INTERVAL").append(" ").append(this._intervalDataTypes.get(object.getStartField()));
            if (object.getStartFieldPrecision() != null) {
                builder.append("(").append(object.getStartFieldPrecision());
                if (object.getEndField() == null && object.getSecondFracs() != null) {
                    builder.append(",").append(" ").append(object.getSecondFracs());
                }
                builder.append(")");
            }
            if (object.getEndField() != null) {
                builder.append(" ").append("TO").append(" ").append(this._intervalDataTypes.get(object.getEndField()));
                if (object.getSecondFracs() != null) {
                    builder.append("(").append(object.getSecondFracs()).append(")");
                }
            }
        }

        static {
            HashMap<IntervalDataType, String> map = new HashMap<IntervalDataType, String>();
            map.put(IntervalDataType.YEAR, "YEAR");
            map.put(IntervalDataType.MONTH, "MONTH");
            map.put(IntervalDataType.DAY, "DAY");
            map.put(IntervalDataType.HOUR, "HOUR");
            map.put(IntervalDataType.MINUTE, "MINUTE");
            map.put(IntervalDataType.SECOND, "SECOND");
            _defaultIntervalDataTypes = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLFloatProcessor
    extends AbstractProcessor<SQLFloat> {
        public SQLFloatProcessor() {
            super(SQLFloat.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SQLFloat object, StringBuilder builder) {
            builder.append("FLOAT");
            if (object.getPrecision() != null) {
                builder.append("(").append(object.getPrecision()).append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLCharProcessor
    extends AbstractProcessor<SQLChar> {
        public SQLCharProcessor() {
            super(SQLChar.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SQLChar object, StringBuilder builder) {
            builder.append("CHARACTER");
            if (object.isVarying().booleanValue()) {
                builder.append(" ").append("VARYING");
            }
            if (object.getLength() != null) {
                builder.append("(").append(object.getLength()).append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NumericProcessor
    extends AbstractProcessor<Numeric> {
        public NumericProcessor() {
            super(Numeric.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, Numeric object, StringBuilder builder) {
            builder.append("NUMERIC");
            if (object.getPrecision() != null) {
                builder.append("(").append(object.getPrecision());
                if (object.getScale() != null) {
                    builder.append(object.getScale());
                }
                builder.append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DecimalProcessor
    extends AbstractProcessor<Decimal> {
        public DecimalProcessor() {
            super(Decimal.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, Decimal object, StringBuilder builder) {
            builder.append("DECIMAL");
            if (object.getPrecision() != null) {
                builder.append("(").append(object.getPrecision());
                if (object.getScale() != null) {
                    builder.append(object.getScale());
                }
                builder.append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserDefinedDataTypeProcessor
    extends AbstractProcessor<UserDefinedType> {
        public UserDefinedDataTypeProcessor() {
            super(UserDefinedType.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, UserDefinedType object, StringBuilder builder) {
            builder.append(object.getTextualRepresentation());
        }
    }
}

