/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.util.HashMap;
import java.util.Map;
import org.atp.api.Typeable;
import org.sql.generation.api.grammar.manipulation.AddColumnDefinition;
import org.sql.generation.api.grammar.manipulation.AddTableConstraintDefinition;
import org.sql.generation.api.grammar.manipulation.AlterColumnAction;
import org.sql.generation.api.grammar.manipulation.AlterColumnDefinition;
import org.sql.generation.api.grammar.manipulation.AlterTableStatement;
import org.sql.generation.api.grammar.manipulation.DropColumnDefinition;
import org.sql.generation.api.grammar.manipulation.DropSchemaStatement;
import org.sql.generation.api.grammar.manipulation.DropTableConstraintDefinition;
import org.sql.generation.api.grammar.manipulation.DropTableOrViewStatement;
import org.sql.generation.api.grammar.manipulation.ObjectType;
import org.sql.generation.api.grammar.manipulation.SetColumnDefault;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.ProcessorUtils;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class ManipulationProcessing {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DropTableOrViewStatementProcessor
    extends AbstractProcessor<DropTableOrViewStatement> {
        private static final Map<ObjectType, String> _defaultObjectTypes;
        private final Map<ObjectType, String> _objectTypes;

        public DropTableOrViewStatementProcessor() {
            this(_defaultObjectTypes);
        }

        public DropTableOrViewStatementProcessor(Map<ObjectType, String> objectTypes) {
            super(DropTableOrViewStatement.class);
            this._objectTypes = objectTypes;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, DropTableOrViewStatement object, StringBuilder builder) {
            builder.append("DROP").append(" ").append(this._objectTypes.get(object.whatToDrop())).append(" ");
            aggregator.process((Typeable<?>)object.getTableName(), builder);
            ProcessorUtils.processDropBehaviour(object.getDropBehaviour(), builder);
        }

        protected Map<ObjectType, String> getObjectTypes() {
            return this._objectTypes;
        }

        static {
            HashMap<ObjectType, String> map = new HashMap<ObjectType, String>();
            map.put(ObjectType.TABLE, "TABLE");
            map.put(ObjectType.VIEW, "VIEW");
            _defaultObjectTypes = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DropSchemaStatementProcessor
    extends AbstractProcessor<DropSchemaStatement> {
        public DropSchemaStatementProcessor() {
            super(DropSchemaStatement.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, DropSchemaStatement object, StringBuilder builder) {
            builder.append("DROP SCHEMA").append(" ").append(object.getSchemaName());
            ProcessorUtils.processDropBehaviour(object.getDropBehaviour(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DropTableConstraintDefinitionProcessor
    extends AbstractProcessor<DropTableConstraintDefinition> {
        public DropTableConstraintDefinitionProcessor() {
            super(DropTableConstraintDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, DropTableConstraintDefinition object, StringBuilder builder) {
            builder.append("DROP CONSTRAINT").append(" ").append(object.getConstraintName());
            ProcessorUtils.processDropBehaviour(object.getDropBehaviour(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DropColumnDefinitionProcessor
    extends AbstractProcessor<DropColumnDefinition> {
        public DropColumnDefinitionProcessor() {
            super(DropColumnDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, DropColumnDefinition object, StringBuilder builder) {
            builder.append("DROP COLUMN").append(" ").append(object.getColumnName());
            ProcessorUtils.processDropBehaviour(object.getDropBehaviour(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetColumnDefaultProcessor
    extends AbstractProcessor<SetColumnDefault> {
        public SetColumnDefaultProcessor() {
            super(SetColumnDefault.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SetColumnDefault object, StringBuilder builder) {
            builder.append("SET").append(" ");
            builder.append(object.getDefault());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DropColumnDefaultProcessor
    extends AbstractProcessor<AlterColumnAction.DropDefault> {
        public DropColumnDefaultProcessor() {
            super(AlterColumnAction.DropDefault.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, AlterColumnAction.DropDefault object, StringBuilder builder) {
            builder.append("DROP DEFAULT");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlterColumnDefinitionProcessor
    extends AbstractProcessor<AlterColumnDefinition> {
        public AlterColumnDefinitionProcessor() {
            super(AlterColumnDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, AlterColumnDefinition object, StringBuilder builder) {
            builder.append("ALTER COLUMN").append(" ").append(object.getColumnName()).append(" ");
            aggregator.process((Typeable<?>)object.getAction(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddTableConstraintDefinitionProcessor
    extends AbstractProcessor<AddTableConstraintDefinition> {
        public AddTableConstraintDefinitionProcessor() {
            super(AddTableConstraintDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, AddTableConstraintDefinition object, StringBuilder builder) {
            builder.append("ADD").append(" ");
            aggregator.process((Typeable<?>)object.getConstraint(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddColumnDefinitionProcessor
    extends AbstractProcessor<AddColumnDefinition> {
        public AddColumnDefinitionProcessor() {
            super(AddColumnDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, AddColumnDefinition object, StringBuilder builder) {
            builder.append("ADD COLUMN").append(" ");
            aggregator.process((Typeable<?>)object.getColumnDefinition(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlterTableStatementProcessor
    extends AbstractProcessor<AlterTableStatement> {
        public AlterTableStatementProcessor() {
            super(AlterTableStatement.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, AlterTableStatement object, StringBuilder builder) {
            builder.append("ALTER TABLE").append(" ");
            aggregator.process((Typeable<?>)object.getTableName(), builder);
            builder.append("\n");
            aggregator.process((Typeable<?>)object.getAction(), builder);
        }
    }
}

