/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.noear.socketd.cluster.ClusterClient;
import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientProvider;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.server.ServerProvider;

public class SocketD {
    static Map<String, ClientProvider> clientProviderMap = new HashMap<String, ClientProvider>();
    static Map<String, ServerProvider> serverProviderMap = new HashMap<String, ServerProvider>();

    public static String version() {
        return "2.3.8-R2";
    }

    public static String protocolVersion() {
        return "1.0";
    }

    public static Server createServer(String schema) {
        Server server = SocketD.createServerOrNull(schema);
        if (server == null) {
            throw new IllegalStateException("No socketd server providers were found: " + schema);
        }
        return server;
    }

    public static Server createServerOrNull(String schema) {
        Asserts.assertNull("schema", schema);
        ServerProvider factory = serverProviderMap.get(schema);
        if (factory == null) {
            return null;
        }
        return factory.createServer(new ServerConfig(schema));
    }

    public static Client createClient(String serverUrl) {
        Client client = SocketD.createClientOrNull(serverUrl);
        if (client == null) {
            throw new IllegalStateException("No socketd client providers were found: " + serverUrl);
        }
        return client;
    }

    public static Client createClientOrNull(String serverUrl) {
        Asserts.assertNull("serverUrl", serverUrl);
        int idx = serverUrl.indexOf("://");
        if (idx < 2) {
            throw new IllegalArgumentException("The serverUrl invalid: " + serverUrl);
        }
        String schema = serverUrl.substring(0, idx);
        ClientProvider factory = clientProviderMap.get(schema);
        if (factory == null) {
            return null;
        }
        ClientConfig clientConfig = new ClientConfig(serverUrl);
        return factory.createClient(clientConfig);
    }

    public static ClusterClient createClusterClient(String ... serverUrls) {
        return new ClusterClient(serverUrls);
    }

    public static ClusterClient createClusterClient(List<String> serverUrls) {
        return new ClusterClient(serverUrls.toArray(new String[serverUrls.size()]));
    }

    static {
        ServiceLoader.load(ClientProvider.class).iterator().forEachRemaining(factory -> {
            for (String s : factory.schemas()) {
                clientProviderMap.put(s, (ClientProvider)factory);
            }
        });
        ServiceLoader.load(ServerProvider.class).iterator().forEachRemaining(factory -> {
            for (String s : factory.schemas()) {
                serverProviderMap.put(s, (ServerProvider)factory);
            }
        });
    }
}

