/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.noear.socketd.SocketD;
import org.noear.socketd.cluster.ClusterClientSession;
import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.client.ClientConfigHandler;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.client.ClientSession;
import org.noear.socketd.transport.core.HeartbeatHandler;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.utils.StrUtils;

public class ClusterClient
implements Client {
    private final String[] serverUrls;
    private HeartbeatHandler heartbeatHandler;
    private ClientConfigHandler configHandler;
    private Listener listener;

    public ClusterClient(String ... serverUrls) {
        this.serverUrls = serverUrls;
    }

    @Override
    public Client heartbeatHandler(HeartbeatHandler heartbeatHandler) {
        this.heartbeatHandler = heartbeatHandler;
        return this;
    }

    @Override
    public Client config(ClientConfigHandler configHandler) {
        this.configHandler = configHandler;
        return this;
    }

    @Override
    public Client listen(Listener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public ClientSession open() throws IOException {
        return this.openDo(false);
    }

    @Override
    public ClientSession openOrThow() throws IOException {
        return this.openDo(true);
    }

    private ClientSession openDo(boolean isThow) throws IOException {
        ArrayList<ClientSession> sessionList = new ArrayList<ClientSession>();
        ExecutorService channelExecutor = null;
        for (String urls : this.serverUrls) {
            for (String url : urls.split(",")) {
                if (StrUtils.isEmpty(url = url.trim())) continue;
                ClientInternal client = (ClientInternal)SocketD.createClient(url);
                if (this.listener != null) {
                    client.listen(this.listener);
                }
                if (this.configHandler != null) {
                    client.config(this.configHandler);
                }
                if (this.heartbeatHandler != null) {
                    client.heartbeatHandler(this.heartbeatHandler);
                }
                if (channelExecutor == null) {
                    channelExecutor = client.getConfig().getChannelExecutor();
                } else {
                    client.getConfig().channelExecutor(channelExecutor);
                }
                if (isThow) {
                    sessionList.add(client.openOrThow());
                    continue;
                }
                sessionList.add(client.open());
            }
        }
        return new ClusterClientSession(sessionList);
    }
}

