/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import org.noear.socketd.exception.SocketdChannelException;
import org.noear.socketd.exception.SocketdSizeLimitException;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.utils.StrUtils;

public class Asserts {
    public static void assertClosed(Channel channel) {
        if (channel != null && channel.isClosed() > 0) {
            throw new SocketdChannelException("This channel is closed, sessionId=" + channel.getSession().sessionId());
        }
    }

    public static boolean isClosedAndEnd(Channel channel) {
        return channel.isClosed() == 29 || channel.isClosed() == 28 || channel.isClosed() == 19;
    }

    public static void assertClosedAndEnd(Channel channel) {
        if (channel != null && Asserts.isClosedAndEnd(channel)) {
            throw new SocketdChannelException("This channel is closed, sessionId=" + channel.getSession().sessionId());
        }
    }

    public static void assertNull(String name, Object val) {
        if (val == null) {
            throw new IllegalArgumentException("The argument cannot be null: " + name);
        }
    }

    public static void assertEmpty(String name, String val) {
        if (StrUtils.isEmpty(val)) {
            throw new IllegalArgumentException("The argument cannot be empty: " + name);
        }
    }

    public static void assertSize(String name, int size, int limitSize) {
        if (size > limitSize) {
            StringBuilder buf = new StringBuilder();
            buf.append("This message ").append(name).append(" size is out of limit ").append(limitSize).append(" (").append(size).append(")");
            throw new SocketdSizeLimitException(buf.toString());
        }
    }
}

