/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.entity;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.noear.socketd.transport.core.entity.EntityDefault;

public class TempfileEntity
extends EntityDefault {
    private final File file;
    private RandomAccessFile fileRaf;

    public TempfileEntity(File file, ByteBuffer data, Map<String, String> metaMap) throws IOException {
        this.file = file;
        this.dataSet(data);
        this.metaMapPut(metaMap);
    }

    public TempfileEntity(File file) throws IOException {
        this.file = file;
        this.fileRaf = new RandomAccessFile(file, "r");
        long len = file.length();
        MappedByteBuffer byteBuffer = this.fileRaf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, len);
        this.dataSet(byteBuffer);
        this.metaPut("Data-Disposition-Filename", file.getName());
    }

    @Override
    public void release() throws IOException {
        if (this.fileRaf != null) {
            this.fileRaf.close();
        }
        this.file.delete();
    }
}

