/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.HandshakeInternal;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.impl.Frames;

public abstract class ChannelBase
implements Channel {
    private final Config config;
    private final Map<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private HandshakeInternal handshake;
    private int isClosed;

    public ChannelBase(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public <T> T getAttachment(String name) {
        return (T)this.attachments.get(name);
    }

    @Override
    public void putAttachment(String name, Object val) {
        if (val == null) {
            this.attachments.remove(name);
        } else {
            this.attachments.put(name, val);
        }
    }

    @Override
    public int isClosed() {
        return this.isClosed;
    }

    @Override
    public void close(int code) {
        this.isClosed = code;
        this.attachments.clear();
    }

    @Override
    public void setHandshake(HandshakeInternal handshake) {
        if (handshake != null) {
            this.handshake = handshake;
        }
    }

    @Override
    public HandshakeInternal getHandshake() {
        return this.handshake;
    }

    @Override
    public void sendConnect(String uri, Map<String, String> metaMap) throws IOException {
        this.send(Frames.connectFrame(this.getConfig().getIdGenerator().generate(), uri, metaMap), null);
    }

    @Override
    public void sendConnack(Message connectMessage) throws IOException {
        this.send(Frames.connackFrame(connectMessage), null);
    }

    @Override
    public void sendPing() throws IOException {
        this.send(Frames.pingFrame(), null);
    }

    @Override
    public void sendPong() throws IOException {
        this.send(Frames.pongFrame(), null);
    }

    @Override
    public void sendClose() throws IOException {
        this.send(Frames.closeFrame(), null);
    }

    @Override
    public void sendAlarm(Message from, String alarm) throws IOException {
        this.send(Frames.alarmFrame(from, alarm), null);
    }
}

