/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.entity.MessageBuilder;
import org.noear.socketd.transport.core.impl.ChannelBase;
import org.noear.socketd.transport.core.impl.SessionDefault;
import org.noear.socketd.transport.stream.StreamInternal;
import org.noear.socketd.transport.stream.StreamManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelDefault<S>
extends ChannelBase
implements ChannelInternal {
    private static Logger log = LoggerFactory.getLogger(ChannelDefault.class);
    private final S source;
    private final Processor processor;
    private final ChannelAssistant<S> assistant;
    private final StreamManger streamManger;
    private Session session;
    private long liveTime;
    private BiConsumer<Boolean, Throwable> onOpenFuture;
    private ReentrantLock SEND_LOCK = new ReentrantLock();

    public ChannelDefault(S source, ChannelSupporter<S> supporter) {
        super(supporter.getConfig());
        this.source = source;
        this.processor = supporter.getProcessor();
        this.assistant = supporter.getAssistant();
        this.streamManger = supporter.getConfig().getStreamManger();
    }

    @Override
    public boolean isValid() {
        return this.isClosed() == 0 && this.assistant.isValid(this.source);
    }

    @Override
    public long getLiveTime() {
        return this.liveTime;
    }

    @Override
    public void setLiveTimeAsNow() {
        this.liveTime = System.currentTimeMillis();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        return this.assistant.getRemoteAddress(this.source);
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return this.assistant.getLocalAddress(this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Frame frame, StreamInternal stream) throws IOException {
        Asserts.assertClosed(this);
        if (log.isDebugEnabled()) {
            if (this.getConfig().clientMode()) {
                log.debug("C-SEN:{}", (Object)frame);
            } else {
                log.debug("S-SEN:{}", (Object)frame);
            }
        }
        this.SEND_LOCK.lock();
        try {
            if (frame.message() != null) {
                MessageInternal message = frame.message();
                if (stream != null) {
                    this.streamManger.addStream(message.sid(), stream);
                }
                if (message.entity() != null) {
                    if (message.dataSize() > this.getConfig().getFragmentSize()) {
                        message.putMeta("Data-Length", String.valueOf(message.dataSize()));
                    }
                    this.getConfig().getFragmentHandler().spliFragment(this, stream, message, fragmentEntity -> {
                        Frame fragmentFrame = fragmentEntity instanceof MessageInternal ? new Frame(frame.flag(), (MessageInternal)fragmentEntity) : new Frame(frame.flag(), new MessageBuilder().flag(frame.flag()).sid(message.sid()).event(message.event()).entity((Entity)fragmentEntity).build());
                        this.assistant.write(this.source, fragmentFrame);
                    });
                    return;
                }
            }
            this.assistant.write(this.source, frame);
            if (stream != null) {
                stream.onProgress(true, 1, 1);
            }
        }
        finally {
            this.SEND_LOCK.unlock();
        }
    }

    @Override
    public void retrieve(Frame frame, StreamInternal stream) {
        if (stream != null) {
            if (stream.demands() < 2 || frame.flag() == 49) {
                this.streamManger.removeStream(frame.message().sid());
            }
            if (stream.demands() < 2) {
                stream.onReply(frame.message());
            } else {
                this.getConfig().getChannelExecutor().submit(() -> stream.onReply(frame.message()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("{} stream not found, sid={}, sessionId={}", new Object[]{this.getConfig().getRoleName(), frame.message().sid(), this.getSession().sessionId()});
        }
    }

    @Override
    public void reconnect() throws IOException {
    }

    @Override
    public void onError(Throwable error) {
        this.processor.onError(this, error);
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            this.session = new SessionDefault(this);
        }
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public StreamInternal getStream(String sid) {
        return this.streamManger.getStream(sid);
    }

    @Override
    public void onOpenFuture(BiConsumer<Boolean, Throwable> future) {
        this.onOpenFuture = future;
    }

    @Override
    public void doOpenFuture(boolean isOk, Throwable error) {
        if (this.onOpenFuture != null) {
            this.onOpenFuture.accept(isOk, error);
        }
    }

    @Override
    public void close(int code) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug("{} channel will be closed, sessionId={}", (Object)this.getConfig().getRoleName(), (Object)this.getSession().sessionId());
            }
            try {
                super.close(code);
                this.assistant.close(this.source);
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("{} channel close error, sessionId={}", new Object[]{this.getConfig().getRoleName(), this.getSession().sessionId(), e});
            }
        }
    }
}

