/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.util.Map;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.MessageBuilder;
import org.noear.socketd.transport.core.entity.StringEntity;

public class Frames {
    public static final Frame connectFrame(String sid, String url, Map<String, String> metaMap) {
        StringEntity entity = new StringEntity(url);
        entity.metaMapPut(metaMap);
        entity.metaPut("Socket.D", SocketD.protocolVersion());
        return new Frame(10, new MessageBuilder().sid(sid).event(url).entity(entity).build());
    }

    public static final Frame connackFrame(Message connectMessage) {
        EntityDefault entity = new EntityDefault();
        entity.metaPut("Socket.D", SocketD.protocolVersion());
        entity.dataSet(connectMessage.entity().data());
        return new Frame(11, new MessageBuilder().sid(connectMessage.sid()).event(connectMessage.event()).entity(entity).build());
    }

    public static final Frame pingFrame() {
        return new Frame(20, null);
    }

    public static final Frame pongFrame() {
        return new Frame(21, null);
    }

    public static final Frame closeFrame() {
        return new Frame(30, null);
    }

    public static final Frame alarmFrame(Message from, String alarm) {
        MessageBuilder message = new MessageBuilder();
        if (from != null) {
            message.sid(from.sid());
            message.event(from.event());
            message.entity(new StringEntity(alarm).metaStringSet(from.metaString()));
        } else {
            message.entity(new StringEntity(alarm));
        }
        return new Frame(31, message.build());
    }
}

