/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.server;

import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.impl.ProcessorDefault;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.server.ServerConfigHandler;

public abstract class ServerBase<T extends ChannelAssistant>
implements Server {
    private Processor processor = new ProcessorDefault();
    private final ServerConfig config;
    private final T assistant;
    protected boolean isStarted;

    public ServerBase(ServerConfig config, T assistant) {
        this.config = config;
        this.assistant = assistant;
    }

    public T getAssistant() {
        return this.assistant;
    }

    @Override
    public ServerConfig getConfig() {
        return this.config;
    }

    @Override
    public Server config(ServerConfigHandler configHandler) {
        if (configHandler != null) {
            configHandler.serverConfig(this.config);
        }
        return this;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public Server listen(Listener listener) {
        if (listener != null) {
            this.processor.setListener(listener);
        }
        return this;
    }
}

