/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.impl.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.kevoree.modeling.api.KMFContainer;
import org.kevoree.modeling.api.json.JSONModelLoader;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.impl.PCMImpl;
import org.opencompare.api.java.impl.io.PCMBase64Encoder;
import org.opencompare.api.java.io.PCMLoader;
import pcm.factory.DefaultPcmFactory;

public class KMFJSONLoader
implements PCMLoader {
    private DefaultPcmFactory kpcmFactory = new DefaultPcmFactory();
    private JSONModelLoader loader = this.kpcmFactory.createJSONLoader();
    private PCMBase64Encoder encoder = new PCMBase64Encoder();
    private boolean base64Decoding;

    public KMFJSONLoader() {
        this(true);
    }

    public KMFJSONLoader(boolean base64Decoding) {
        this.base64Decoding = base64Decoding;
    }

    public List<PCMContainer> load(String json) {
        List containers = this.loader.loadModelFromString(json);
        return this.load(containers);
    }

    public List<PCMContainer> load(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        String json = new String(bytes, StandardCharsets.UTF_8);
        return this.load(json);
    }

    private List<PCMContainer> load(List<KMFContainer> containers) {
        ArrayList<PCMContainer> containersPCM = new ArrayList<PCMContainer>();
        for (KMFContainer container : containers) {
            PCMImpl pcm = new PCMImpl((pcm.PCM)container);
            this.encoder.decode(pcm);
            PCMContainer containerPCM = new PCMContainer();
            PCMMetadata metadata = new PCMMetadata((PCM)pcm);
            containerPCM.setPcm((PCM)pcm);
            containerPCM.setMetadata(metadata);
            containersPCM.add(containerPCM);
        }
        return containersPCM;
    }
}

