/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.clustering;

import org.opencompare.api.java.clustering.ClusteringDissimilarityMeasure;
import org.opencompare.api.java.clustering.ClusteringExperiment;
import org.opencompare.api.java.clustering.HierarchicalClusterer$;
import org.opencompare.hac.ClusteringBuilder;
import org.opencompare.hac.HierarchicalAgglomerativeClusterer;
import org.opencompare.hac.agglomeration.AgglomerationMethod;
import org.opencompare.hac.dendrogram.Dendrogram;
import org.opencompare.hac.dendrogram.DendrogramBuilder;
import org.opencompare.hac.dendrogram.DendrogramNode;
import org.opencompare.hac.dendrogram.MergeNode;
import org.opencompare.hac.dendrogram.ObservationNode;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u0011Q\u0003S5fe\u0006\u00148\r[5dC2\u001cE.^:uKJ,'O\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011\u0001\u00026bm\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005Yq\u000e]3oG>l\u0007/\u0019:f\u0015\u0005Y\u0011aA8sO\u000e\u0001QC\u0001\b\u001e'\t\u0001q\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\u0005\t-\u0001\u0011)\u0019!C\u0001/\u0005\u0019B-[:tS6LG.\u0019:jiflU\r\u001e:jGV\t\u0001\u0004E\u0003\u00113mYb%\u0003\u0002\u001b#\tIa)\u001e8di&|gN\r\t\u00039ua\u0001\u0001B\u0003\u001f\u0001\t\u0007qDA\u0001U#\t\u00013\u0005\u0005\u0002\u0011C%\u0011!%\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001B%\u0003\u0002&#\t\u0019\u0011I\\=\u0011\u0005A9\u0013B\u0001\u0015\u0012\u0005\u0019!u.\u001e2mK\"A!\u0006\u0001B\u0001B\u0003%\u0001$\u0001\u000beSN\u001c\u0018.\\5mCJLG/_'fiJL7\r\t\u0005\tY\u0001\u0011)\u0019!C\u0001[\u0005IA\u000f\u001b:fg\"|G\u000eZ\u000b\u0002]A\u0019\u0001c\f\u0014\n\u0005A\n\"AB(qi&|g\u000e\u0003\u00053\u0001\t\u0005\t\u0015!\u0003/\u0003)!\bN]3tQ>dG\r\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005qQ.\u0019=DYV\u001cH/\u001a:TSj,W#\u0001\u001c\u0011\u0007Ays\u0007\u0005\u0002\u0011q%\u0011\u0011(\u0005\u0002\u0004\u0013:$\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u001f5\f\u0007p\u00117vgR,'oU5{K\u0002B\u0001\"\u0010\u0001\u0003\u0006\u0004%\tAP\u0001\u0011[\u0016\u0014x-\u001b8h\u0007>tG-\u001b;j_:,\u0012a\u0010\t\u0004!=\u0002\u0005#\u0002\t\u001a\u0003\u0006k\u0005c\u0001\"K79\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r2\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005%\u000b\u0012a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013A\u0001T5ti*\u0011\u0011*\u0005\t\u0003!9K!aT\t\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u000b\u0001B\u0001B\u0003%q(A\tnKJ<\u0017N\\4D_:$\u0017\u000e^5p]\u0002B\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001V\u0001\u0014C\u001e<Gn\\7fe\u0006$\u0018n\u001c8NKRDw\u000eZ\u000b\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u000eC\u001e<Gn\\7fe\u0006$\u0018n\u001c8\u000b\u0005iC\u0011a\u00015bG&\u0011Al\u0016\u0002\u0014\u0003\u001e<Gn\\7fe\u0006$\u0018n\u001c8NKRDw\u000e\u001a\u0005\t=\u0002\u0011\t\u0011)A\u0005+\u0006!\u0012mZ4m_6,'/\u0019;j_:lU\r\u001e5pI\u0002BQ\u0001\u0019\u0001\u0005\u0002\u0005\fa\u0001P5oSRtDC\u00022eK\u001a<\u0007\u000eE\u0002d\u0001mi\u0011A\u0001\u0005\u0006-}\u0003\r\u0001\u0007\u0005\u0006Y}\u0003\rA\f\u0005\u0006i}\u0003\rA\u000e\u0005\u0006{}\u0003\ra\u0010\u0005\b'~\u0003\n\u00111\u0001V\u0011\u0015Q\u0007\u0001\"\u0001l\u0003\u001d\u0019G.^:uKJ$\"\u0001\\7\u0011\u0007\tS\u0015\tC\u0003oS\u0002\u0007\u0011)\u0001\u0004wC2,Xm\u001d\u0005\u0006a\u0002!I!]\u0001\u0010Kb$(/Y2u\u00072,8\u000f^3sgR\u0019AN]<\t\u000bM|\u0007\u0019\u0001;\u0002\u0015\u0015D\b/\u001a:j[\u0016tG\u000fE\u0002dknI!A\u001e\u0002\u0003)\rcWo\u001d;fe&tw-\u0012=qKJLW.\u001a8u\u0011\u0015Ax\u000e1\u0001z\u0003)!WM\u001c3s_\u001e\u0014\u0018-\u001c\t\u0003url\u0011a\u001f\u0006\u0003qfK!!`>\u0003\u0015\u0011+g\u000e\u001a:pOJ\fWn\u0002\u0005\u0000\u0005\u0005\u0005\t\u0012AA\u0001\u0003UA\u0015.\u001a:be\u000eD\u0017nY1m\u00072,8\u000f^3sKJ\u00042aYA\u0002\r!\t!!!A\t\u0002\u0005\u00151cAA\u0002\u001f!9\u0001-a\u0001\u0005\u0002\u0005%ACAA\u0001\u0011)\ti!a\u0001\u0012\u0002\u0013\u0005\u0011qB\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\t\u0005E\u0011qE\u000b\u0003\u0003'Q3!VA\u000bW\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0011#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00121\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002\u0010\u0002\f\t\u0007q\u0004")
public class HierarchicalClusterer<T> {
    private final Function2<T, T, Object> dissimilarityMetric;
    private final Option<Object> threshold;
    private final Option<Object> maxClusterSize;
    private final Option<Function2<List<T>, List<T>, Object>> mergingCondition;
    private final AgglomerationMethod agglomerationMethod;

    public static <T> AgglomerationMethod $lessinit$greater$default$5() {
        return HierarchicalClusterer$.MODULE$.$lessinit$greater$default$5();
    }

    public Function2<T, T, Object> dissimilarityMetric() {
        return this.dissimilarityMetric;
    }

    public Option<Object> threshold() {
        return this.threshold;
    }

    public Option<Object> maxClusterSize() {
        return this.maxClusterSize;
    }

    public Option<Function2<List<T>, List<T>, Object>> mergingCondition() {
        return this.mergingCondition;
    }

    public AgglomerationMethod agglomerationMethod() {
        return this.agglomerationMethod;
    }

    public List<List<T>> cluster(List<T> values) {
        ClusteringExperiment experiment = new ClusteringExperiment(values.toIndexedSeq());
        ClusteringDissimilarityMeasure<T> dissimilarityMeasure = new ClusteringDissimilarityMeasure<T>(this.dissimilarityMetric());
        DendrogramBuilder dendrogramBuilder = new DendrogramBuilder(experiment.getNumberOfObservations());
        HierarchicalAgglomerativeClusterer clusterer = new HierarchicalAgglomerativeClusterer(experiment, dissimilarityMeasure, this.agglomerationMethod());
        clusterer.cluster((ClusteringBuilder)dendrogramBuilder);
        return this.extractClusters(experiment, dendrogramBuilder.getDendrogram());
    }

    private List<List<T>> extractClusters(ClusteringExperiment<T> experiment, Dendrogram dendrogram) {
        return Option$.MODULE$.apply((Object)dendrogram.getRoot()).isDefined() ? this.extractClustersRecursion$1(dendrogram.getRoot(), experiment) : Nil$.MODULE$;
    }

    private final List extractClustersRecursion$1(DendrogramNode node, ClusteringExperiment experiment$1) {
        DendrogramNode dendrogramNode;
        block7: {
            List list;
            block6: {
                block5: {
                    List list2;
                    dendrogramNode = node;
                    if (!(dendrogramNode instanceof MergeNode)) break block5;
                    MergeNode mergeNode = (MergeNode)dendrogramNode;
                    List left = this.extractClustersRecursion$1(mergeNode.getLeft(), experiment$1);
                    List right = this.extractClustersRecursion$1(mergeNode.getRight(), experiment$1);
                    if (!(left.size() != 1 || right.size() != 1 || this.threshold().isDefined() && !(mergeNode.getDissimilarity() < BoxesRunTime.unboxToDouble((Object)this.threshold().get())) || this.maxClusterSize().isDefined() && ((SeqLike)left.head()).size() + ((SeqLike)right.head()).size() > BoxesRunTime.unboxToInt((Object)this.maxClusterSize().get()) || this.mergingCondition().isDefined() && !BoxesRunTime.unboxToBoolean((Object)((Function2)this.mergingCondition().get()).apply(left.head(), right.head())))) {
                        List[] listArray = new List[1];
                        List list3 = left;
                        listArray[0] = (List)right.$colon$colon$colon(list3).flatten((Function1)Predef$.MODULE$.$conforms());
                        list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])listArray));
                    } else {
                        List list4 = left;
                        list2 = right.$colon$colon$colon(list4);
                    }
                    list = list2;
                    break block6;
                }
                if (!(dendrogramNode instanceof ObservationNode)) break block7;
                ObservationNode observationNode = (ObservationNode)dendrogramNode;
                List[] listArray = new List[1];
                Object t = experiment$1.getObservation(observationNode.getObservation());
                listArray[0] = Nil$.MODULE$.$colon$colon(t);
                list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])listArray));
            }
            return list;
        }
        throw new MatchError((Object)dendrogramNode);
    }

    public HierarchicalClusterer(Function2<T, T, Object> dissimilarityMetric, Option<Object> threshold, Option<Object> maxClusterSize, Option<Function2<List<T>, List<T>, Object>> mergingCondition, AgglomerationMethod agglomerationMethod) {
        this.dissimilarityMetric = dissimilarityMetric;
        this.threshold = threshold;
        this.maxClusterSize = maxClusterSize;
        this.mergingCondition = mergingCondition;
        this.agglomerationMethod = agglomerationMethod;
    }
}

