/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.BoolArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class BoolArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        BoolArray array = new BoolArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((boolean[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        BoolArray array = new BoolArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((boolean[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        boolean[] raw = new boolean[]{true, false};
        BoolArray array = new BoolArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
            Assert.assertEquals((Object)raw[i], (Object)((boolean[])array.copyArray())[i]);
        }
    }

    @Test
    public void testAddValue() {
        boolean[] raw = new boolean[]{true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        boolean e0 = true;
        boolean e1 = false;
        array.addValue(true);
        array.addValue(false);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
        }
        Assert.assertEquals((Object)true, (Object)array.getValue(0));
        Assert.assertEquals((Object)false, (Object)array.getValue(1));
    }

    public void testRemoveValue() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }

    public void testGetValue() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
        }
    }

    @Test
    public void testSetValue() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        boolean e0 = false;
        boolean e2 = true;
        boolean e4 = false;
        array.setValue(0, false);
        array.setValue(2, true);
        array.setValue(4, false);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)false, (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(1));
        Assert.assertEquals((Object)true, (Object)array.getValue(2));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(3));
        Assert.assertEquals((Object)false, (Object)array.getValue(4));
    }

    @Test
    public void testAddValueIndex() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        boolean e0 = true;
        boolean e4 = false;
        boolean e7 = true;
        array.addValue(0, true);
        array.addValue(4, false);
        array.addValue(7, true);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((Object)true, (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[0], (Object)array.getValue(1));
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(2));
        Assert.assertEquals((Object)raw[2], (Object)array.getValue(3));
        Assert.assertEquals((Object)false, (Object)array.getValue(4));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(5));
        Assert.assertEquals((Object)raw[4], (Object)array.getValue(6));
        Assert.assertEquals((Object)true, (Object)array.getValue(7));
    }

    public void testRemoveIndex() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }

    @Test
    public void testIndexOf() {
        boolean[] raw = new boolean[]{true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
    }

    @Test
    public void testLastIndexOf() {
        boolean[] raw = new boolean[]{true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
    }

    @Test
    public void testContains() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
    }

    @Test
    public void testSetArray() {
        BoolArray array = new BoolArray();
        boolean[] raw = new boolean[]{true, false, false, true, false};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        this.testInsert((PrimitiveArray<?, ?>)new BoolArray(raw));
    }

    @Test
    public void testDelete() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        this.testDelete((PrimitiveArray<?, ?>)new BoolArray(raw));
    }

    @Test
    public void testGet() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.get(i));
        }
    }

    @Test
    public void testSet() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        Boolean e0 = false;
        Boolean e2 = true;
        Boolean e4 = false;
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.get(0));
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.get(2));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.get(4));
    }

    @Test
    public void testAdd() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        Boolean e6 = true;
        Boolean e7 = false;
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.get(5));
        Assert.assertEquals((Object)e7, (Object)array.get(6));
    }

    @Test
    public void testIndexOfBoxed() {
        boolean[] raw = new boolean[]{true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Boolean(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not a bool"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        boolean[] raw = new boolean[]{false, true};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Boolean(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not a bool"));
    }

    @Test
    public void testContainsBoxed() {
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Boolean(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not a bool"));
    }

    @Test
    public void testRemove() {
        boolean[] raw = new boolean[]{true, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Boolean(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Boolean(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }

    @Test
    public void testContainsAll() {
        boolean[] raw = new boolean[]{true, true};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(true);
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(false);
        Assert.assertFalse((boolean)array.containsAll(list));
        BoolArray yes = new BoolArray(new boolean[]{true});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        BoolArray no = new BoolArray(new boolean[]{false, true});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        boolean[] raw = new boolean[]{true, false, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        boolean[] add = new boolean[]{true, false};
        BoolArray toAdd = new BoolArray((boolean[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)raw[i], (Object)array.getValue(i));
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((Object)add[i - 3], (Object)array.getValue(i));
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((Object)raw[i - add.length], (Object)array.getValue(i));
        }
    }

    @Test
    public void testRemoveAll() {
        boolean[] raw = new boolean[]{true, false, true, false};
        BoolArray array = new BoolArray((boolean[])raw.clone());
        BoolArray toRemove = new BoolArray(new boolean[]{true, true});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }
}

