/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class IntArray
extends AbstractPrimitiveArray<int[], Integer> {
    private int[] array;

    public IntArray() {
        super(Integer.TYPE);
    }

    public IntArray(int size) {
        super(Integer.TYPE, size);
    }

    public IntArray(int[] array) {
        super(Integer.TYPE, array);
    }

    public void addValue(int value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(int value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public int getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public int setValue(int index, int value) {
        this.checkBounds(index);
        int oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, int value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public int[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(int[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Integer get(int index) {
        return this.getValue(index);
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.setValue(index, element == null ? this.defaultValue() : element);
    }

    @Override
    public void add(int index, Integer element) {
        this.addValue(index, element);
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Integer)) {
            return -1;
        }
        int value = (Integer)o;
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Integer)) {
            return -1;
        }
        int value = (Integer)o;
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        int value = (Integer)o;
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        int value = (Integer)o;
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Integer)) {
                return false;
            }
            int value = (Integer)o;
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Integer> iterator = c.iterator();
        while (iterator.hasNext()) {
            int e = iterator.next();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            int value;
            boolean result;
            if (!(o instanceof Integer) || !(result = this.removeValue(value = ((Integer)o).intValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Integer defaultValue() {
        return 0;
    }
}

