/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.download;

import java.io.IOException;
import java.util.Date;
import org.scijava.download.Download;
import org.scijava.download.DownloadService;
import org.scijava.download.LocationCache;
import org.scijava.download.MultiWriteHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.task.Task;
import org.scijava.task.TaskService;

@Plugin(type=Service.class)
public class DefaultDownloadService
extends AbstractService
implements DownloadService {
    @Parameter
    private DataHandleService dataHandleService;
    @Parameter
    private TaskService taskService;

    @Override
    public Download download(Location source, Location destination) {
        Task task = this.taskService.createTask("Download");
        return new DefaultDownload(source, destination, task, () -> {
            try (DataHandle in = (DataHandle)this.dataHandleService.create(source);
                 DataHandle out = (DataHandle)this.dataHandleService.create(destination);){
                task.setStatusMessage("Downloading " + source.getURI());
                this.copy(task, in, out);
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
        });
    }

    @Override
    public Download download(Location source, Location destination, LocationCache cache) {
        if (cache == null || !cache.canCache(source)) {
            return this.download(source, destination);
        }
        Task task = this.taskService.createTask("Download");
        return new DefaultDownload(source, destination, task, () -> {
            Location cached = cache.cachedLocation(source);
            try (DataHandle sourceHandle = (DataHandle)this.dataHandleService.create(source);
                 DataHandle cachedHandle = (DataHandle)this.dataHandleService.create(cached);
                 DataHandle destHandle = (DataHandle)this.dataHandleService.create(destination);){
                if (this.isCachedHandleValid(source, cache, sourceHandle, cachedHandle)) {
                    task.setStatusMessage("Retrieving " + source.getURI());
                    this.copy(task, cachedHandle, destHandle);
                } else {
                    task.setStatusMessage("Downloading + caching " + source.getURI());
                    this.copy(task, sourceHandle, new MultiWriteHandle(cachedHandle, destHandle));
                }
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
        });
    }

    private void copy(Task task, DataHandle<Location> in, DataHandle<Location> out) throws IOException {
        long length;
        try {
            length = in.length();
        }
        catch (IOException exc) {
            length = 0L;
        }
        if (length > 0L) {
            task.setProgressMaximum(length);
        }
        int chunkSize = 65536;
        byte[] buf = new byte[65536];
        while (true) {
            if (task.isCanceled()) {
                return;
            }
            int r = in.read(buf);
            if (r <= 0) break;
            if (task.isCanceled()) {
                return;
            }
            out.write(buf, 0, r);
            if (length <= 0L) continue;
            task.setProgressValue(task.getProgressValue() + (long)r);
        }
    }

    private boolean isCachedHandleValid(Location source, LocationCache cache, DataHandle<Location> sourceHandle, DataHandle<Location> cachedHandle) throws IOException {
        if (!cachedHandle.exists()) {
            return false;
        }
        long sourceLen = sourceHandle.length();
        long cachedLen = cachedHandle.length();
        if (sourceLen >= 0L && cachedLen >= 0L && sourceLen != cachedLen) {
            return false;
        }
        Date sourceDate = sourceHandle.lastModified();
        Date cachedDate = cachedHandle.lastModified();
        if (sourceDate != null && cachedDate != null && sourceDate.after(cachedDate)) {
            return false;
        }
        String sourceChecksum = sourceHandle.checksum();
        String cachedChecksum = cache.loadChecksum(source);
        return sourceChecksum == null || cachedChecksum == null || sourceChecksum.equals(cachedChecksum);
    }

    private class DefaultDownload
    implements Download {
        private Location source;
        private Location destination;
        private Task task;

        private DefaultDownload(Location source, Location destination, Task task, Runnable r) {
            this.source = source;
            this.destination = destination;
            this.task = task;
            task.run(r);
        }

        @Override
        public Location source() {
            return this.source;
        }

        @Override
        public Location destination() {
            return this.destination;
        }

        @Override
        public Task task() {
            return this.task;
        }
    }
}

