/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.Serializable;
import org.scijava.util.Colors;

public class ColorRGB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int red;
    private final int green;
    private final int blue;

    public ColorRGB(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ColorRGB(String s) {
        ColorRGB result = ColorRGB.fromHTMLColor(s);
        if (result != null) {
            this.red = result.red;
            this.green = result.green;
            this.blue = result.blue;
        } else {
            String[] tokens = s.split(",");
            this.red = this.parse(tokens, 0);
            this.green = this.parse(tokens, 1);
            this.blue = this.parse(tokens, 2);
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return 255;
    }

    public int getARGB() {
        int a = this.getAlpha();
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        return a << 24 | r << 16 | g << 8 | b;
    }

    public String toHTMLColor() {
        String preset = Colors.getName(this);
        if (preset != null) {
            return preset;
        }
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public String toString() {
        return this.red + "," + this.green + "," + this.blue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorRGB)) {
            return super.equals(obj);
        }
        ColorRGB other = (ColorRGB)obj;
        return this.getRed() == other.getRed() && this.getGreen() == other.getGreen() && this.getBlue() == other.getBlue() && this.getAlpha() == other.getAlpha();
    }

    public int hashCode() {
        return this.getARGB();
    }

    public static ColorRGB fromHTMLColor(String color) {
        if (color.startsWith("#")) {
            String hexColor = color.length() == 4 ? new String(new char[]{color.charAt(0), color.charAt(1), color.charAt(1), color.charAt(2), color.charAt(2), color.charAt(3), color.charAt(3)}) : color;
            int red = Integer.parseInt(hexColor.substring(1, 3), 16);
            int green = Integer.parseInt(hexColor.substring(3, 5), 16);
            int blue = Integer.parseInt(hexColor.substring(5, 7), 16);
            return new ColorRGB(red, green, blue);
        }
        return Colors.getColor(color);
    }

    public static ColorRGB fromHSVColor(double h, double s, double v) {
        return ColorRGB.hsvToRgb(h, s, v);
    }

    private int parse(String[] s, int index) {
        if (s == null || index >= s.length) {
            return 0;
        }
        try {
            return Integer.parseInt(s[index]);
        }
        catch (NumberFormatException exc) {
            return 0;
        }
    }

    private static ColorRGB hsvToRgb(double h, double s, double v) {
        double r01 = 0.0;
        double g01 = 0.0;
        double b01 = 0.0;
        int i = (int)Math.floor(h * 6.0);
        double f = h * 6.0 - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - f * s);
        double t = v * (1.0 - (1.0 - f) * s);
        switch (i % 6) {
            case 0: {
                r01 = v;
                g01 = t;
                b01 = p;
                break;
            }
            case 1: {
                r01 = q;
                g01 = v;
                b01 = p;
                break;
            }
            case 2: {
                r01 = p;
                g01 = v;
                b01 = t;
                break;
            }
            case 3: {
                r01 = p;
                g01 = q;
                b01 = v;
                break;
            }
            case 4: {
                r01 = t;
                g01 = p;
                b01 = v;
                break;
            }
            case 5: {
                r01 = v;
                g01 = p;
                b01 = q;
            }
        }
        int r255 = (int)Math.round(r01 * 255.0);
        int g255 = (int)Math.round(g01 * 255.0);
        int b255 = (int)Math.round(b01 * 255.0);
        return new ColorRGB(r255, g255, b255);
    }
}

