/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.sjep.AbstractTest;
import org.scijava.sjep.ExpressionParser;
import org.scijava.sjep.Operator;
import org.scijava.sjep.Operators;

public class ExpressionParserTest
extends AbstractTest {
    @Test
    public void testStrings() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("'hello'*\"world\"");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)3L, (long)queue.size());
        this.assertString("hello", queue.get(0));
        this.assertString("world", queue.get(1));
    }

    @Test
    public void testNumbers() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("1.1+2L+3f+4-+5d-6");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)11L, (long)queue.size());
        this.assertNumber(1.1, queue.get(0));
        this.assertNumber(2L, queue.get(1));
        this.assertNumber(Float.valueOf(3.0f), queue.get(3));
        this.assertNumber(4, queue.get(5));
        this.assertNumber(5.0, queue.get(7));
        this.assertNumber(6, queue.get(9));
    }

    @Test
    public void testOperatorsIndividual() {
        ExpressionParser p = new ExpressionParser();
        this.assertBinary(p, "a", Operators.DOT, "b", "a.b");
        this.assertUnary(p, "a", Operators.TRANSPOSE, "a'");
        this.assertUnary(p, "a", Operators.DOT_TRANSPOSE, "a.'");
        this.assertBinary(p, "a", Operators.POW, "b", "a^b");
        this.assertBinary(p, "a", Operators.DOT_POW, "b", "a.^b");
        this.assertUnary(p, "a", Operators.PRE_INC, "++a");
        this.assertUnary(p, "a", Operators.POST_INC, "a++");
        this.assertUnary(p, "a", Operators.PRE_DEC, "--a");
        this.assertUnary(p, "a", Operators.POST_DEC, "a--");
        this.assertUnary(p, "a", Operators.POS, "+a");
        this.assertUnary(p, "a", Operators.NEG, "-a");
        this.assertUnary(p, "a", Operators.COMPLEMENT, "~a");
        this.assertUnary(p, "a", Operators.NOT, "!a");
        this.assertBinary(p, "a", Operators.MUL, "b", "a*b");
        this.assertBinary(p, "a", Operators.DIV, "b", "a/b");
        this.assertBinary(p, "a", Operators.MOD, "b", "a%b");
        this.assertBinary(p, "a", Operators.ADD, "b", "a+b");
        this.assertBinary(p, "a", Operators.SUB, "b", "a-b");
        this.assertBinary(p, "a", Operators.LEFT_SHIFT, "b", "a<<b");
        this.assertBinary(p, "a", Operators.RIGHT_SHIFT, "b", "a>>b");
        this.assertBinary(p, "a", Operators.UNSIGNED_RIGHT_SHIFT, "b", "a>>>b");
        this.assertBinary(p, "a", Operators.COLON, "b", "a:b");
        this.assertBinary(p, "a", Operators.LESS_THAN, "b", "a<b");
        this.assertBinary(p, "a", Operators.GREATER_THAN, "b", "a>b");
        this.assertBinary(p, "a", Operators.LESS_THAN_OR_EQUAL, "b", "a<=b");
        this.assertBinary(p, "a", Operators.GREATER_THAN_OR_EQUAL, "b", "a>=b");
        this.assertBinary(p, "a", Operators.INSTANCEOF, "b", "a instanceof b");
        this.assertBinary(p, "a", Operators.EQUAL, "b", "a==b");
        this.assertBinary(p, "a", Operators.NOT_EQUAL, "b", "a!=b");
        this.assertBinary(p, "a", Operators.BITWISE_AND, "b", "a&b");
        this.assertBinary(p, "a", Operators.BITWISE_OR, "b", "a|b");
        this.assertBinary(p, "a", Operators.LOGICAL_AND, "b", "a&&b");
        this.assertBinary(p, "a", Operators.LOGICAL_OR, "b", "a||b");
        this.assertBinary(p, "a", Operators.ASSIGN, "b", "a=b");
        this.assertBinary(p, "a", Operators.POW_ASSIGN, "b", "a^=b");
        this.assertBinary(p, "a", Operators.DOT_POW_ASSIGN, "b", "a.^=b");
        this.assertBinary(p, "a", Operators.MUL_ASSIGN, "b", "a*=b");
        this.assertBinary(p, "a", Operators.DIV_ASSIGN, "b", "a/=b");
        this.assertBinary(p, "a", Operators.MOD_ASSIGN, "b", "a%=b");
        this.assertBinary(p, "a", Operators.RIGHT_DIV_ASSIGN, "b", "a\\=b");
        this.assertBinary(p, "a", Operators.DOT_DIV_ASSIGN, "b", "a./=b");
        this.assertBinary(p, "a", Operators.DOT_RIGHT_DIV_ASSIGN, "b", "a.\\=b");
        this.assertBinary(p, "a", Operators.ADD_ASSIGN, "b", "a+=b");
        this.assertBinary(p, "a", Operators.SUB_ASSIGN, "b", "a-=b");
        this.assertBinary(p, "a", Operators.AND_ASSIGN, "b", "a&=b");
        this.assertBinary(p, "a", Operators.OR_ASSIGN, "b", "a|=b");
        this.assertBinary(p, "a", Operators.LEFT_SHIFT_ASSIGN, "b", "a<<=b");
        this.assertBinary(p, "a", Operators.RIGHT_SHIFT_ASSIGN, "b", "a>>=b");
        this.assertBinary(p, "a", Operators.UNSIGNED_RIGHT_SHIFT_ASSIGN, "b", "a>>>=b");
    }

    @Test
    public void testMathOperators() {
        String expression = "(a|=b)|(c&=d)&(e>>>=f)>>>(g>>=h)>>(i<<=j)<<(k-=l)-(m+=n)+(o.\\=p).\\(q./=r)./(s\\=t)\\(u%=v)%(w/=x)/(y*=z)*(aa.^=bb).^(cc^=dd)^f(~ee--,-ff++,+--gg',++hh.')";
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("(a|=b)|(c&=d)&(e>>>=f)>>>(g>>=h)>>(i<<=j)<<(k-=l)-(m+=n)+(o.\\=p).\\(q./=r)./(s\\=t)\\(u%=v)%(w/=x)/(y*=z)*(aa.^=bb).^(cc^=dd)^f(~ee--,-ff++,+--gg',++hh.')");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)74L, (long)queue.size());
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        Assert.assertSame((Object)Operators.OR_ASSIGN, queue.get(2));
        this.assertVariable("c", queue.get(3));
        this.assertVariable("d", queue.get(4));
        Assert.assertSame((Object)Operators.AND_ASSIGN, queue.get(5));
        this.assertVariable("e", queue.get(6));
        this.assertVariable("f", queue.get(7));
        Assert.assertSame((Object)Operators.UNSIGNED_RIGHT_SHIFT_ASSIGN, queue.get(8));
        this.assertVariable("g", queue.get(9));
        this.assertVariable("h", queue.get(10));
        Assert.assertSame((Object)Operators.RIGHT_SHIFT_ASSIGN, queue.get(11));
        Assert.assertSame((Object)Operators.UNSIGNED_RIGHT_SHIFT, queue.get(12));
        this.assertVariable("i", queue.get(13));
        this.assertVariable("j", queue.get(14));
        Assert.assertSame((Object)Operators.LEFT_SHIFT_ASSIGN, queue.get(15));
        Assert.assertSame((Object)Operators.RIGHT_SHIFT, queue.get(16));
        this.assertVariable("k", queue.get(17));
        this.assertVariable("l", queue.get(18));
        Assert.assertSame((Object)Operators.SUB_ASSIGN, queue.get(19));
        this.assertVariable("m", queue.get(20));
        this.assertVariable("n", queue.get(21));
        Assert.assertSame((Object)Operators.ADD_ASSIGN, queue.get(22));
        Assert.assertSame((Object)Operators.SUB, queue.get(23));
        this.assertVariable("o", queue.get(24));
        this.assertVariable("p", queue.get(25));
        Assert.assertSame((Object)Operators.DOT_RIGHT_DIV_ASSIGN, queue.get(26));
        this.assertVariable("q", queue.get(27));
        this.assertVariable("r", queue.get(28));
        Assert.assertSame((Object)Operators.DOT_DIV_ASSIGN, queue.get(29));
        Assert.assertSame((Object)Operators.DOT_RIGHT_DIV, queue.get(30));
        this.assertVariable("s", queue.get(31));
        this.assertVariable("t", queue.get(32));
        Assert.assertSame((Object)Operators.RIGHT_DIV_ASSIGN, queue.get(33));
        Assert.assertSame((Object)Operators.DOT_DIV, queue.get(34));
        this.assertVariable("u", queue.get(35));
        this.assertVariable("v", queue.get(36));
        Assert.assertSame((Object)Operators.MOD_ASSIGN, queue.get(37));
        Assert.assertSame((Object)Operators.RIGHT_DIV, queue.get(38));
        this.assertVariable("w", queue.get(39));
        this.assertVariable("x", queue.get(40));
        Assert.assertSame((Object)Operators.DIV_ASSIGN, queue.get(41));
        Assert.assertSame((Object)Operators.MOD, queue.get(42));
        this.assertVariable("y", queue.get(43));
        this.assertVariable("z", queue.get(44));
        Assert.assertSame((Object)Operators.MUL_ASSIGN, queue.get(45));
        Assert.assertSame((Object)Operators.DIV, queue.get(46));
        this.assertVariable("aa", queue.get(47));
        this.assertVariable("bb", queue.get(48));
        Assert.assertSame((Object)Operators.DOT_POW_ASSIGN, queue.get(49));
        this.assertVariable("cc", queue.get(50));
        this.assertVariable("dd", queue.get(51));
        Assert.assertSame((Object)Operators.POW_ASSIGN, queue.get(52));
        this.assertVariable("ee", queue.get(53));
        Assert.assertSame((Object)Operators.POST_DEC, queue.get(54));
        Assert.assertSame((Object)Operators.COMPLEMENT, queue.get(55));
        this.assertVariable("ff", queue.get(56));
        Assert.assertSame((Object)Operators.POST_INC, queue.get(57));
        Assert.assertSame((Object)Operators.NEG, queue.get(58));
        this.assertVariable("gg", queue.get(59));
        Assert.assertSame((Object)Operators.TRANSPOSE, queue.get(60));
        Assert.assertSame((Object)Operators.PRE_DEC, queue.get(61));
        Assert.assertSame((Object)Operators.POS, queue.get(62));
        this.assertVariable("hh", queue.get(63));
        Assert.assertSame((Object)Operators.DOT_TRANSPOSE, queue.get(64));
        Assert.assertSame((Object)Operators.PRE_INC, queue.get(65));
        this.assertFunction("f", 4, queue.get(66));
        Assert.assertSame((Object)Operators.POW, queue.get(67));
        Assert.assertSame((Object)Operators.DOT_POW, queue.get(68));
        Assert.assertSame((Object)Operators.MUL, queue.get(69));
        Assert.assertSame((Object)Operators.ADD, queue.get(70));
        Assert.assertSame((Object)Operators.LEFT_SHIFT, queue.get(71));
        Assert.assertSame((Object)Operators.BITWISE_AND, queue.get(72));
        Assert.assertSame((Object)Operators.BITWISE_OR, queue.get(73));
    }

    public void testLogicOperators() {
        String expression = "a<b || c>d && e<=f || g>=h && i==j || k!=l && m instanceof n || !o";
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a<b || c>d && e<=f || g>=h && i==j || k!=l && m instanceof n || !o");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)30L, (long)queue.size());
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        Assert.assertSame((Object)Operators.LESS_THAN, queue.get(2));
        this.assertVariable("c", queue.get(3));
        this.assertVariable("d", queue.get(4));
        Assert.assertSame((Object)Operators.GREATER_THAN, queue.get(5));
        this.assertVariable("e", queue.get(6));
        this.assertVariable("f", queue.get(7));
        Assert.assertSame((Object)Operators.LESS_THAN_OR_EQUAL, queue.get(8));
        Assert.assertSame((Object)Operators.LOGICAL_AND, queue.get(9));
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.get(10));
        this.assertVariable("g", queue.get(11));
        this.assertVariable("h", queue.get(12));
        Assert.assertSame((Object)Operators.GREATER_THAN_OR_EQUAL, queue.get(13));
        this.assertVariable("i", queue.get(14));
        this.assertVariable("j", queue.get(15));
        Assert.assertSame((Object)Operators.EQUAL, queue.get(16));
        Assert.assertSame((Object)Operators.LOGICAL_AND, queue.get(17));
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.get(18));
        this.assertVariable("k", queue.get(19));
        this.assertVariable("l", queue.get(20));
        Assert.assertSame((Object)Operators.NOT_EQUAL, queue.get(21));
        this.assertVariable("m", queue.get(22));
        this.assertVariable("n", queue.get(23));
        Assert.assertSame((Object)Operators.INSTANCEOF, queue.get(24));
        Assert.assertSame((Object)Operators.LOGICAL_AND, queue.get(25));
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.get(26));
        this.assertVariable("0", queue.get(27));
        Assert.assertSame((Object)Operators.NOT, queue.get(28));
        Assert.assertSame((Object)Operators.LOGICAL_OR, queue.get(29));
    }

    @Test
    public void testUnaryOperators1() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("-+a");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        Assert.assertSame((Object)Operators.POS, queue.get(1));
        Assert.assertSame((Object)Operators.NEG, queue.get(2));
    }

    @Test
    public void testUnaryOperators2() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a+-b");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        Assert.assertSame((Object)Operators.NEG, queue.get(2));
        Assert.assertSame((Object)Operators.ADD, queue.get(3));
    }

    @Test
    public void testUnaryOperators3() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a-+-b");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        Assert.assertSame((Object)Operators.NEG, queue.get(2));
        Assert.assertSame((Object)Operators.POS, queue.get(3));
        Assert.assertSame((Object)Operators.SUB, queue.get(4));
    }

    @Test
    public void testUnaryOperators4() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("-+a-+-b");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        Assert.assertSame((Object)Operators.POS, queue.get(1));
        Assert.assertSame((Object)Operators.NEG, queue.get(2));
        this.assertVariable("b", queue.get(3));
        Assert.assertSame((Object)Operators.NEG, queue.get(4));
        Assert.assertSame((Object)Operators.POS, queue.get(5));
        Assert.assertSame((Object)Operators.SUB, queue.get(6));
    }

    @Test
    public void testNullaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f()");
        Assert.assertNotNull((Object)queue);
        this.assertFunction("f", 0, queue.get(0));
    }

    @Test
    public void testUnaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(a)");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        this.assertFunction("f", 1, queue.get(1));
    }

    @Test
    public void testBinaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(a,b)");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        this.assertFunction("f", 2, queue.get(2));
    }

    @Test
    public void testTernaryFunction() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(a,b,c)");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        this.assertVariable("c", queue.get(2));
        this.assertFunction("f", 3, queue.get(3));
    }

    @Test
    public void testNestedFunctions() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("f(g(),a,h(b),i(c,d))");
        Assert.assertNotNull((Object)queue);
        this.assertFunction("g", 0, queue.get(0));
        this.assertVariable("a", queue.get(1));
        this.assertVariable("b", queue.get(2));
        this.assertFunction("h", 1, queue.get(3));
        this.assertVariable("c", queue.get(4));
        this.assertVariable("d", queue.get(5));
        this.assertFunction("i", 2, queue.get(6));
        this.assertFunction("f", 4, queue.get(7));
    }

    @Test
    public void testOperatorPrecedence() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a+b*c^d.^e'");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)10L, (long)queue.size());
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        this.assertVariable("c", queue.get(2));
        this.assertVariable("d", queue.get(3));
        this.assertVariable("e", queue.get(4));
        Assert.assertSame((Object)Operators.DOT_POW, queue.get(5));
        Assert.assertSame((Object)Operators.POW, queue.get(6));
        Assert.assertSame((Object)Operators.TRANSPOSE, queue.get(7));
        Assert.assertSame((Object)Operators.MUL, queue.get(8));
        Assert.assertSame((Object)Operators.ADD, queue.get(9));
    }

    @Test
    public void testOperatorAssociativity() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("(a/b/c)+(a^b^c)");
        Assert.assertNotNull((Object)queue);
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        Assert.assertSame((Object)Operators.DIV, queue.get(2));
        this.assertVariable("c", queue.get(3));
        Assert.assertSame((Object)Operators.DIV, queue.get(4));
        this.assertVariable("a", queue.get(5));
        this.assertVariable("b", queue.get(6));
        this.assertVariable("c", queue.get(7));
        Assert.assertSame((Object)Operators.POW, queue.get(8));
        Assert.assertSame((Object)Operators.POW, queue.get(9));
        Assert.assertSame((Object)Operators.ADD, queue.get(10));
    }

    @Test
    public void testParsePostfix() {
        ExpressionParser parser = new ExpressionParser();
        LinkedList queue = parser.parsePostfix("a*b-c*a/func(quick,brown,fox)^foo^bar");
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)16L, (long)queue.size());
        this.assertVariable("a", queue.get(0));
        this.assertVariable("b", queue.get(1));
        Assert.assertSame((Object)Operators.MUL, queue.get(2));
        this.assertVariable("c", queue.get(3));
        this.assertVariable("a", queue.get(4));
        Assert.assertSame((Object)Operators.MUL, queue.get(5));
        this.assertVariable("quick", queue.get(6));
        this.assertVariable("brown", queue.get(7));
        this.assertVariable("fox", queue.get(8));
        this.assertFunction("func", 3, queue.get(9));
        this.assertVariable("foo", queue.get(10));
        this.assertVariable("bar", queue.get(11));
        Assert.assertSame((Object)Operators.POW, queue.get(12));
        Assert.assertSame((Object)Operators.POW, queue.get(13));
        Assert.assertSame((Object)Operators.DIV, queue.get(14));
        Assert.assertSame((Object)Operators.SUB, queue.get(15));
    }

    @Test
    public void testEmpty() {
        ExpressionParser parser = new ExpressionParser();
        Assert.assertEquals((long)0L, (long)parser.parsePostfix("").size());
        Assert.assertEquals((long)0L, (long)parser.parsePostfix("()").size());
        Assert.assertEquals((long)0L, (long)parser.parsePostfix("(())").size());
    }

    @Test
    public void testInvalid() {
        ExpressionParser parser = new ExpressionParser();
        this.assertInvalid(parser, "a a", "Invalid character at index 2");
        this.assertInvalid(parser, "func(,)", "Invalid character at index 5");
        this.assertInvalid(parser, "foo,bar", "Misplaced separator or mismatched parentheses at index 4");
        this.assertInvalid(parser, "(", "Mismatched parentheses at index 1");
        this.assertInvalid(parser, ")", "Mismatched parentheses at index 1");
        this.assertInvalid(parser, ")(", "Mismatched parentheses at index 1");
        this.assertInvalid(parser, "(()", "Mismatched parentheses at index 3");
    }

    private void assertUnary(ExpressionParser parser, String var, Operator op, String expression) {
        LinkedList queue = parser.parsePostfix(expression);
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)2L, (long)queue.size());
        this.assertVariable(var, queue.get(0));
        Assert.assertSame((Object)op, queue.get(1));
    }

    private void assertBinary(ExpressionParser parser, String var1, Operator op, String var2, String expression) {
        LinkedList queue = parser.parsePostfix(expression);
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((long)3L, (long)queue.size());
        this.assertVariable(var1, queue.get(0));
        this.assertVariable(var2, queue.get(1));
        Assert.assertSame((Object)op, queue.get(2));
    }

    private void assertInvalid(ExpressionParser parser, String expression, String message) {
        try {
            parser.parsePostfix(expression);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertEquals((Object)message, (Object)exc.getMessage());
        }
    }
}

