/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.visitors;

import com.google.common.base.Preconditions;
import java.io.File;
import org.sonar.api.config.Settings;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.plugins.javascript.api.AstTreeVisitorContext;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

public class AstTreeVisitorContextImpl
implements AstTreeVisitorContext {
    private final ScriptTree tree;
    private final SourceFile sourceFile;
    private final File file;
    private final SymbolModel symbolModel;
    private final Settings settings;

    public AstTreeVisitorContextImpl(ScriptTree tree, SourceFile sourceFile, File file, SymbolModel symbolModel, Settings settings) {
        this.tree = tree;
        this.sourceFile = sourceFile;
        this.file = file;
        this.symbolModel = symbolModel;
        this.settings = settings;
    }

    @Override
    public ScriptTree getTopTree() {
        return this.tree;
    }

    @Override
    public void addIssue(JavaScriptCheck check, Tree tree, String message) {
        this.commonAddIssue(check, this.getLine(tree), message, -1.0);
    }

    @Override
    public void addIssue(JavaScriptCheck check, int line, String message) {
        this.commonAddIssue(check, line, message, -1.0);
    }

    @Override
    public void addIssue(JavaScriptCheck check, Tree tree, String message, double cost) {
        this.commonAddIssue(check, this.getLine(tree), message, cost);
    }

    @Override
    public void addIssue(JavaScriptCheck check, int line, String message, double cost) {
        this.commonAddIssue(check, line, message, cost);
    }

    @Override
    public String getFileKey() {
        return this.sourceFile.getKey();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    private void commonAddIssue(JavaScriptCheck check, int line, String message, double cost) {
        Preconditions.checkNotNull((Object)check);
        Preconditions.checkNotNull((Object)message);
        CheckMessage checkMessage = new CheckMessage((Object)check, message, new Object[0]);
        if (cost > 0.0) {
            checkMessage.setCost(cost);
        }
        if (line > 0) {
            checkMessage.setLine(line);
        }
        this.sourceFile.log(checkMessage);
    }

    private int getLine(Tree tree) {
        return ((JavaScriptTree)tree).getLine();
    }

    @Override
    public SymbolModel getSymbolModel() {
        return this.symbolModel;
    }

    @Override
    public String[] getPropertyValues(String name) {
        return this.settings.getStringArray(name);
    }
}

