/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class ComplexityVisitor
extends SquidAstVisitor<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.IF_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.CASE_CLAUSE, Tree.Kind.CATCH_BLOCK, Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT, EcmaScriptPunctuator.QUERY, EcmaScriptPunctuator.ANDAND, EcmaScriptPunctuator.OROR});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.RETURN_STATEMENT}) && ComplexityVisitor.isLastReturnStatement(astNode)) {
            return;
        }
        this.getContext().peekSourceCode().add((MetricDef)EcmaScriptMetric.COMPLEXITY, 1.0);
    }

    private static boolean isLastReturnStatement(AstNode returnNode) {
        AstNode nextNode = returnNode.getNextAstNode();
        return nextNode.is(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE}) && ComplexityVisitor.isNotNested(returnNode);
    }

    private static boolean isNotNested(AstNode returnNode) {
        return returnNode.getParent().is(new AstNodeType[]{Tree.Kind.BLOCK}) && returnNode.getParent().getParent().is(new AstNodeType[]{Tree.Kind.SET_METHOD, Tree.Kind.GET_METHOD, Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION});
    }
}

