/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.declaration;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class BindingPropertyTreeImpl
extends JavaScriptTree
implements BindingPropertyTree {
    private final ExpressionTree name;
    private final SyntaxToken colonToken;
    private final BindingElementTree value;

    public BindingPropertyTreeImpl(ExpressionTree name, InternalSyntaxToken colonToken, BindingElementTree value) {
        super(Tree.Kind.BINDING_PROPERTY);
        this.name = name;
        this.colonToken = colonToken;
        this.value = value;
        this.addChildren((AstNode)name, colonToken, (AstNode)value);
    }

    @Override
    public ExpressionTree name() {
        return this.name;
    }

    @Override
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public BindingElementTree value() {
        return this.value;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BINDING_PROPERTY;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.name, this.value});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBindingProperty(this);
    }
}

