/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class TemplateCharactersTreeImpl
extends JavaScriptTree
implements TemplateCharactersTree {
    private final String value;

    public TemplateCharactersTreeImpl(List<AstNode> characters) {
        super(Tree.Kind.TEMPLATE_CHARACTERS);
        StringBuilder builder = new StringBuilder();
        for (AstNode character : characters) {
            builder.append(character.getTokenValue());
            this.addChild(character);
        }
        this.value = builder.toString();
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TEMPLATE_CHARACTERS;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.emptyIterator();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTemplateCharacters(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

