/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class TemplateExpressionTreeImpl
extends JavaScriptTree
implements TemplateExpressionTree {
    private final InternalSyntaxToken dollar;
    private final InternalSyntaxToken openCurlyBrace;
    private InternalSyntaxToken closeCurlyBrace;
    private final ExpressionTree expression;

    public TemplateExpressionTreeImpl(InternalSyntaxToken dollar, InternalSyntaxToken openCurlyBrace, ExpressionTree expression) {
        super(Tree.Kind.TEMPLATE_EXPRESSION);
        this.dollar = dollar;
        this.openCurlyBrace = openCurlyBrace;
        this.expression = expression;
        this.addChildren(dollar, openCurlyBrace, (AstNode)expression);
    }

    public TemplateExpressionTreeImpl complete(InternalSyntaxToken closeCurlyBrace) {
        this.closeCurlyBrace = closeCurlyBrace;
        this.addChild(closeCurlyBrace);
        return this;
    }

    @Override
    public SyntaxToken dollar() {
        return this.dollar;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TEMPLATE_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.expression);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTemplateExpression(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

