/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class TemplateLiteralTreeImpl
extends JavaScriptTree
implements TemplateLiteralTree {
    private final SyntaxToken openBacktick;
    private final List<TemplateCharactersTree> strings;
    private final List<TemplateExpressionTree> expressions;
    private final SyntaxToken closeBacktick;

    public TemplateLiteralTreeImpl(InternalSyntaxToken openBacktick, List<TemplateCharactersTree> strings, List<TemplateExpressionTree> expressions, InternalSyntaxToken closeBacktick, List<AstNode> children) {
        super(Tree.Kind.TEMPLATE_LITERAL);
        this.openBacktick = openBacktick;
        this.strings = strings;
        this.expressions = expressions;
        this.closeBacktick = closeBacktick;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public TemplateLiteralTreeImpl(InternalSyntaxToken openBacktick, List<TemplateCharactersTree> strings, InternalSyntaxToken closeBacktick) {
        super(Tree.Kind.TEMPLATE_LITERAL);
        this.openBacktick = openBacktick;
        this.strings = strings;
        this.expressions = ListUtils.EMPTY_LIST;
        this.closeBacktick = closeBacktick;
        this.addChild(openBacktick);
        this.addChildren(strings.toArray(new AstNode[strings.size()]));
        this.addChild(closeBacktick);
    }

    @Override
    public SyntaxToken openBacktick() {
        return this.openBacktick;
    }

    @Override
    public List<TemplateCharactersTree> strings() {
        return this.strings;
    }

    @Override
    public List<TemplateExpressionTree> expressions() {
        return this.expressions;
    }

    @Override
    public SyntaxToken closeBacktick() {
        return this.closeBacktick;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TEMPLATE_LITERAL;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.strings.iterator(), this.expressions.iterator());
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTemplateLiteral(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

