/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class BreakStatementTreeImpl
extends JavaScriptTree
implements BreakStatementTree {
    private SyntaxToken breakKeyword;
    @Nullable
    private final IdentifierTree label;

    public BreakStatementTreeImpl(AstNode eos) {
        super(Tree.Kind.BREAK_STATEMENT);
        this.label = null;
        this.addChild(eos);
    }

    public BreakStatementTreeImpl(IdentifierTree label, AstNode eos) {
        super(Tree.Kind.BREAK_STATEMENT);
        this.label = label;
        this.addChild((AstNode)label);
        this.addChild(eos);
    }

    public BreakStatementTreeImpl complete(InternalSyntaxToken breakKeyword) {
        Preconditions.checkState((this.breakKeyword == null ? 1 : 0) != 0, (Object)"Already completed");
        this.breakKeyword = breakKeyword;
        this.prependChildren(breakKeyword);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BREAK_STATEMENT;
    }

    @Override
    public SyntaxToken breakKeyword() {
        return this.breakKeyword;
    }

    @Override
    @Nullable
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public Tree endOfStatement() {
        throw new UnsupportedOperationException("Not supported yet in the strongly typed AST.");
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.label);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBreakStatement(this);
    }
}

