/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.statement;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.model.internal.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.internal.statement.BlockTreeImpl;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class CatchBlockTreeImpl
extends JavaScriptTree
implements CatchBlockTree {
    private final SyntaxToken catchKeyword;
    private final SyntaxToken openParenthesis;
    private final BindingElementTree parameter;
    private final SyntaxToken closeParenthesis;
    private final BlockTree block;

    public CatchBlockTreeImpl(InternalSyntaxToken catchKeyword, InternalSyntaxToken openParenthesis, BindingElementTree parameter, InternalSyntaxToken closeParenthesis, BlockTreeImpl block) {
        super(Tree.Kind.CATCH_BLOCK);
        this.catchKeyword = catchKeyword;
        this.openParenthesis = openParenthesis;
        this.parameter = parameter;
        this.closeParenthesis = closeParenthesis;
        this.block = block;
        this.addChildren(catchKeyword, openParenthesis, (AstNode)parameter, closeParenthesis, block);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CATCH_BLOCK;
    }

    @Override
    public SyntaxToken catchKeyword() {
        return this.catchKeyword;
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public Tree parameter() {
        return this.parameter;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.parameter, this.block});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCatchBlock(this);
    }

    public List<IdentifierTree> parameterIdentifiers() {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        if (this.parameter.is(Tree.Kind.BINDING_IDENTIFIER)) {
            return Lists.newArrayList((Object[])new IdentifierTree[]{(IdentifierTree)this.parameter});
        }
        if (this.parameter.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
            bindingIdentifiers.addAll(((ObjectBindingPatternTreeImpl)this.parameter).bindingIdentifiers());
        } else {
            bindingIdentifiers.addAll(((ArrayBindingPatternTreeImpl)this.parameter).bindingIdentifiers());
        }
        return bindingIdentifiers;
    }
}

