/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.internal.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.model.internal.JavaScriptTree;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class DefaultClauseTreeImpl
extends JavaScriptTree
implements DefaultClauseTree {
    private final SyntaxToken defaultKeyword;
    private final SyntaxToken colon;
    private final List<StatementTree> statements;

    public DefaultClauseTreeImpl(InternalSyntaxToken defaultKeyword, InternalSyntaxToken colon) {
        super(Tree.Kind.DEFAULT_CLAUSE);
        this.defaultKeyword = defaultKeyword;
        this.colon = colon;
        this.statements = ListUtils.EMPTY_LIST;
        this.addChildren(defaultKeyword, colon);
    }

    public DefaultClauseTreeImpl(InternalSyntaxToken defaultKeyword, InternalSyntaxToken colon, List<StatementTree> statements) {
        super(Tree.Kind.DEFAULT_CLAUSE);
        this.defaultKeyword = defaultKeyword;
        this.colon = colon;
        this.statements = statements;
        this.addChildren(defaultKeyword, colon);
        for (StatementTree child : statements) {
            this.addChild((AstNode)child);
        }
    }

    @Override
    public SyntaxToken keyword() {
        return this.defaultKeyword;
    }

    @Override
    public SyntaxToken colon() {
        return this.colon;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.DEFAULT_CLAUSE;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator[])new Iterator[]{this.statements.iterator()});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDefaultClause(this);
    }
}

