/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaConstItem;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlMetaType;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMetaConst
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Case caseConversion;
    private boolean not;
    private List<SqlMetaConstItem> elements = new ArrayList<SqlMetaConstItem>();
    private SqlType sqlType;

    SqlMetaConst(SqlInputValue.Case caseConversion) {
        this(caseConversion, false);
    }

    SqlMetaConst(SqlInputValue.Case caseConversion, boolean not) {
        this(caseConversion, false, new SqlType());
    }

    SqlMetaConst(SqlInputValue.Case caseConversion, boolean not, SqlType type) {
        this.caseConversion = caseConversion;
        this.not = not;
        this.sqlType = type;
    }

    void addConst(String name) {
        SqlMetaConstItem lastItem;
        int size = this.elements.size();
        SqlMetaConstItem sqlMetaConstItem = lastItem = size > 0 ? this.elements.get(size - 1) : null;
        if (lastItem != null) {
            lastItem.setType(SqlMetaConstItem.Type.REF);
        }
        this.elements.add(new SqlMetaConstItem(name, SqlMetaConstItem.Type.VAL));
    }

    void addConst(SqlMetaConstItem element) {
        this.elements.add(element);
    }

    void setMetaType(String sMetaType) {
        this.sqlType = new SqlType(sMetaType, this.sqlType);
    }

    void setHibernateType(String sHibernateType) {
        this.sqlType = new SqlType(sHibernateType);
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult();
        Object obj = null;
        if (ctx.staticInputValues != null) {
            obj = ctx.staticInputValues;
            for (SqlMetaConstItem item : this.elements) {
                if (obj == null) continue;
                obj = SqlUtils.invokeMethod(obj, item.get(), item.is());
            }
        }
        if (obj == null || obj instanceof Collection && ((Collection)obj).isEmpty() || obj.toString().length() <= 0) {
            result.addFalse();
        } else {
            result.addTrue();
        }
        if (obj != null) {
            if (obj instanceof Collection) {
                int size = ((Collection)obj).size();
                StringBuilder s = new StringBuilder(size > 0 ? "(" : "");
                boolean first = true;
                for (Object objItem : (Collection)obj) {
                    if (first) {
                        first = false;
                    } else {
                        s.append(',');
                    }
                    if (objItem != null) {
                        s.append(this.getData(objItem));
                        continue;
                    }
                    s.append("null");
                }
                if (size > 0) {
                    s.append(')');
                }
                result.setSql(s);
            } else {
                result.setSql(new StringBuilder(this.getData(obj)));
            }
        } else {
            result.setSql(new StringBuilder(""));
        }
        return result;
    }

    private String getData(Object obj) {
        if (obj instanceof String) {
            if (this.caseConversion == SqlInputValue.Case.UPPER) {
                return "'" + obj.toString().toUpperCase() + "'";
            }
            if (this.caseConversion == SqlInputValue.Case.LOWER) {
                return "'" + obj.toString().toLowerCase() + "'";
            }
            return "'" + obj.toString() + "'";
        }
        if (obj.getClass().isEnum() && this.sqlType != null) {
            if (this.sqlType.getMetaType() == SqlMetaType.ENUM_STRING) {
                Method m = SqlUtils.getMethodEnumToValue(obj.getClass());
                if (m != null) {
                    return "'" + (String)SqlUtils.invokeMethod(m, obj) + "'";
                }
                return "'" + obj.toString() + "'";
            }
            if (this.sqlType.getMetaType() == SqlMetaType.ENUM_INT) {
                Method m = SqlUtils.getMethodEnumToValue(obj.getClass());
                if (m != null) {
                    return SqlUtils.invokeMethod(m, obj).toString();
                }
                return obj.toString();
            }
            return obj.toString();
        }
        return obj.toString();
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        Object obj = null;
        if (ctx.staticInputValues != null) {
            obj = ctx.staticInputValues;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DataConst process expression " + obj.getClass() + " " + obj + " " + this.sqlType);
            }
            for (SqlMetaConstItem item : this.elements) {
                if (obj != null) {
                    obj = SqlUtils.invokeMethod(obj, item.get(), item.is());
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("DataConst process expression " + item + " " + (obj != null ? obj.getClass() : "null class") + " " + obj + " " + item.get() + " " + item.is());
            }
        }
        boolean result = false;
        if (obj != null) {
            if (obj instanceof Boolean) {
                result = (Boolean)obj;
            } else if (obj instanceof String) {
                String str = ((String)obj).trim();
                result = str.length() > 0 && !str.toLowerCase().equals("false");
            } else if (obj instanceof Number) {
                result = ((Number)obj).longValue() > 0L;
            } else if (obj.getClass().isEnum() && this.sqlType != null) {
                Method m;
                if (obj.toString().equals(this.sqlType.getValue())) {
                    return true;
                }
                if (this.sqlType.getMetaType() == SqlMetaType.ENUM_STRING) {
                    m = SqlUtils.getMethodEnumToValue(obj.getClass());
                    if (m != null) {
                        return ((String)SqlUtils.invokeMethod(m, obj)).equals(this.sqlType.getValue());
                    }
                    return false;
                }
                if (this.sqlType.getMetaType() == SqlMetaType.ENUM_INT) {
                    m = SqlUtils.getMethodEnumToValue(obj.getClass());
                    if (m != null) {
                        return SqlUtils.invokeMethod(m, obj).toString().equals(this.sqlType.getValue());
                    }
                    return false;
                }
                result = true;
            } else {
                result = true;
            }
        }
        return this.not ? !result : result;
    }
}

