/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.sqlproc.engine.impl.SqlMetaType;
import org.sqlproc.engine.impl.SqlUtils;

class SqlType {
    private SqlMetaType metaType;
    private Type hibernateType;
    private String value;
    static Map<String, Field> hibernateTypes;
    static Map<Class<?>, Type> hibernateTypes2;

    SqlType() {
        this.metaType = SqlMetaType.UNKNOWN;
        this.hibernateType = null;
    }

    SqlType(SqlMetaType metaType, Type hibernateType) {
        this.metaType = metaType;
        this.hibernateType = hibernateType;
    }

    SqlType(String sHibernateType) {
        this.metaType = SqlMetaType.HIBERNATE;
        sHibernateType = sHibernateType.toUpperCase();
        Field f = hibernateTypes.get(sHibernateType);
        if (f != null) {
            try {
                this.hibernateType = (Type)f.get(null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Unsupported Hibernate Type " + sHibernateType);
        }
    }

    SqlType(String sMetaType, SqlType previousType) {
        this.metaType = SqlMetaType.metaToTypeMap.get(sMetaType.toUpperCase());
        if (this.metaType != null) {
            this.hibernateType = previousType != null && previousType.getMetaType() == SqlMetaType.HIBERNATE ? previousType.getHibernateType() : null;
        } else {
            throw new RuntimeException("Unsupported Meta Type " + sMetaType);
        }
    }

    Type getHibernateType() {
        return this.hibernateType != null ? this.hibernateType : this.metaType.getHibernateType();
    }

    Type getHibernateType(Class<?> pojoClass, String attributeName) {
        Class<?> attributeType = SqlUtils.getFieldType(pojoClass, attributeName);
        return hibernateTypes2.get(attributeType);
    }

    SqlMetaType getMetaType() {
        return this.metaType;
    }

    void setResult(Object resultInstance, String attributeName, Object resultValue) {
        this.metaType.setResult(resultInstance, attributeName, resultValue, this.getHibernateType());
    }

    void setParameter(Query query, String paramName, Object inputValue) {
        this.metaType.setParameter(query, paramName, inputValue, this.getHibernateType());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Type{");
        sb.append((Object)this.metaType).append(",h=").append(this.hibernateType).append(",v=").append(this.value).append("}");
        return sb.toString();
    }

    static {
        Field[] fields;
        hibernateTypes = new HashMap<String, Field>();
        for (Field f : fields = Hibernate.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                if (!(f.get(null) instanceof Type)) continue;
                hibernateTypes.put(f.getName().toUpperCase(), f);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        hibernateTypes2 = new HashMap();
        hibernateTypes2.put(Integer.TYPE, (Type)Hibernate.INTEGER);
        hibernateTypes2.put(Integer.class, (Type)Hibernate.INTEGER);
        hibernateTypes2.put(Long.TYPE, (Type)Hibernate.LONG);
        hibernateTypes2.put(Long.class, (Type)Hibernate.LONG);
        hibernateTypes2.put(Short.TYPE, (Type)Hibernate.SHORT);
        hibernateTypes2.put(Short.class, (Type)Hibernate.SHORT);
        hibernateTypes2.put(Float.TYPE, (Type)Hibernate.FLOAT);
        hibernateTypes2.put(Float.class, (Type)Hibernate.FLOAT);
        hibernateTypes2.put(Double.TYPE, (Type)Hibernate.DOUBLE);
        hibernateTypes2.put(Double.class, (Type)Hibernate.DOUBLE);
        hibernateTypes2.put(Character.TYPE, (Type)Hibernate.CHARACTER);
        hibernateTypes2.put(Character.class, (Type)Hibernate.CHARACTER);
        hibernateTypes2.put(String.class, (Type)Hibernate.STRING);
        hibernateTypes2.put(Date.class, (Type)Hibernate.TIMESTAMP);
        hibernateTypes2.put(Boolean.TYPE, (Type)Hibernate.BOOLEAN);
        hibernateTypes2.put(Boolean.class, (Type)Hibernate.BOOLEAN);
        hibernateTypes2.put(BigInteger.class, (Type)Hibernate.BIG_INTEGER);
        hibernateTypes2.put(BigDecimal.class, (Type)Hibernate.BIG_DECIMAL);
        hibernateTypes2.put(byte[].class, (Type)Hibernate.BINARY);
        hibernateTypes2.put(Byte[].class, (Type)Hibernate.WRAPPER_BINARY);
    }
}

