/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlUtils;

enum SqlMetaType {
    INT((Type)Hibernate.INTEGER, new Class[]{Integer.class, Integer.TYPE}, new String[]{"INT", "INTEGER"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Integer.TYPE, Integer.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("INT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.INTEGER);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("INT parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.INTEGER);
                } else {
                    query.setInteger(paramName, ((Integer)inputValue).intValue());
                }
            }
        }
    }
    ,
    LONG((Type)Hibernate.LONG, new Class[]{Long.class, Long.TYPE}, new String[]{"LONG"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Long.TYPE, Long.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("LONG result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("LONG result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.LONG);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("LONG parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.LONG);
                } else {
                    query.setLong(paramName, ((Long)inputValue).longValue());
                }
            }
        }
    }
    ,
    BYTE((Type)Hibernate.BYTE, new Class[]{Byte.class, Byte.TYPE}, new String[]{"BYTE"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Byte.TYPE, Byte.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BYTE result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("BYTE result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.BYTE);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("BYTE parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.BYTE);
                } else {
                    query.setByte(paramName, ((Byte)inputValue).byteValue());
                }
            }
        }
    }
    ,
    BYTE_ARRAY((Type)Hibernate.BINARY, new Class[]{byte[].class, Byte[].class}, new String[]{"BYTEARR", "BYTEARRAY", "BYTES"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BYTE_ARRAY result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
            if (resultValue instanceof byte[]) {
                Method m = SqlUtils.getSetter(pojo, attributeName, byte[].class);
                if (m != null) {
                    SqlUtils.invokeMethod(m, pojo, resultValue);
                } else {
                    m = SqlUtils.getSetter(pojo, attributeName, Byte[].class);
                    if (m != null) {
                        SqlUtils.invokeMethod(m, pojo, SqlUtils.toBytes((byte[])resultValue));
                    }
                }
            } else if (resultValue instanceof Byte[]) {
                Method m = SqlUtils.getSetter(pojo, attributeName, Byte[].class);
                if (m != null) {
                    SqlUtils.invokeMethod(m, pojo, resultValue);
                }
            } else {
                throw new RuntimeException("Incorrect binary array " + resultValue);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.BINARY);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("BYTE_ARRAY parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof byte[]) {
                    query.setBinary(paramName, (byte[])inputValue);
                } else if (inputValue instanceof Byte[]) {
                    query.setBinary(paramName, SqlUtils.toBytes((Byte[])inputValue));
                } else {
                    throw new RuntimeException("Incorrect binary array " + inputValue);
                }
            }
        }
    }
    ,
    SHORT((Type)Hibernate.SHORT, new Class[]{Short.class, Short.TYPE}, new String[]{"SHORT"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Short.TYPE, Short.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SHORT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("SHORT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.SHORT);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("SHORT parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.SHORT);
                } else {
                    query.setShort(paramName, ((Short)inputValue).shortValue());
                }
            }
        }
    }
    ,
    STRING((Type)Hibernate.STRING, new Class[]{String.class}, new String[]{"STRING", "STR"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, String.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("STRING result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("STRING result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.STRING);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("STRING parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.STRING);
                } else {
                    query.setString(paramName, (String)inputValue);
                }
            }
        }
    }
    ,
    CHAR((Type)Hibernate.CHARACTER, new Class[]{Character.class, Character.TYPE}, new String[]{"CHARACTER", "CHAR"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Character.TYPE, Character.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("CHAR result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("CHAR result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.CHARACTER);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CHAR parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.CHARACTER);
                } else {
                    query.setCharacter(paramName, ((Character)inputValue).charValue());
                }
            }
        }
    }
    ,
    DATE((Type)Hibernate.DATE, new Class[]{Date.class}, new String[]{"DATE"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Date.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DATE result " + pojo + " " + attributeName + " " + resultValue.getClass() + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                m = SqlUtils.getSetter(pojo, attributeName, LocalDate.class);
                if (m != null) {
                    LocalDate dt = new LocalDate(resultValue);
                    SqlUtils.invokeMethod(m, pojo, dt);
                } else {
                    this.logger.error("DATE result " + pojo + " " + attributeName + " " + resultValue.getClass() + " " + resultValue + " " + hibernateType);
                }
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.DATE);
            } else {
                DateTime dt = null;
                dt = inputValue instanceof LocalDate ? ((LocalDate)inputValue).toDateTimeAtStartOfDay() : new DateTime(inputValue).withTime(0, 0, 0, 0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("DATE parameter " + paramName + " " + inputValue + " " + hibernateType + " " + dt);
                }
                query.setTimestamp(paramName, dt.toDate());
            }
        }
    }
    ,
    FROMDATE((Type)Hibernate.DATE, new Class[]{Date.class}, new String[]{"FROMDATE"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.DATE);
            } else {
                DateTime dt = new DateTime(inputValue).withTime(0, 0, 0, 0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("FROMDATE parameter " + paramName + " " + inputValue + " " + hibernateType + " " + dt);
                }
                query.setTimestamp(paramName, dt.toDate());
            }
        }
    }
    ,
    TODATE((Type)Hibernate.DATE, new Class[]{Date.class}, new String[]{"TODATE"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.DATE);
            } else {
                DateTime dt = new DateTime(inputValue).withTime(0, 0, 0, 0).plusDays(1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("TODATE parameter " + paramName + " " + inputValue + " " + hibernateType + " " + dt);
                }
                query.setTimestamp(paramName, dt.toDate());
            }
        }
    }
    ,
    TIME((Type)Hibernate.TIME, new Class[]{Date.class}, new String[]{"TIME"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Date.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("TIME result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                m = SqlUtils.getSetter(pojo, attributeName, LocalTime.class);
                if (m != null) {
                    LocalTime dt = new LocalTime(resultValue);
                    SqlUtils.invokeMethod(m, pojo, dt);
                } else {
                    this.logger.error("TIME result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
                }
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.TIME);
            } else {
                DateTime dt = new DateTime(inputValue).withMillisOfSecond(0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("TIME parameter " + paramName + " " + inputValue + " " + hibernateType + " " + dt);
                }
                query.setTime(paramName, dt.toDate());
            }
        }
    }
    ,
    DATETIME((Type)Hibernate.TIMESTAMP, new Class[]{Date.class}, new String[]{"DATETIME"}){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Date.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DATETIME result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                if (resultValue instanceof Timestamp) {
                    ((Timestamp)resultValue).setNanos(0);
                    SqlUtils.invokeMethod(m, pojo, resultValue);
                    return;
                } else {
                    if (!(resultValue instanceof Date)) throw new RuntimeException("Incorrect datetime " + resultValue);
                    SqlUtils.invokeMethod(m, pojo, resultValue);
                }
                return;
            } else {
                m = SqlUtils.getSetter(pojo, attributeName, LocalDateTime.class);
                if (m != null) {
                    LocalDateTime dt = new LocalDateTime(resultValue);
                    SqlUtils.invokeMethod(m, pojo, dt);
                    return;
                } else {
                    this.logger.error("DATETIME result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
                }
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.TIMESTAMP);
            } else {
                DateTime dt = new DateTime(inputValue).withMillisOfSecond(0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("DATETIME parameter " + paramName + " " + inputValue + " " + hibernateType + " " + dt);
                }
                query.setTimestamp(paramName, dt.toDate());
            }
        }
    }
    ,
    TIMESTAMP((Type)Hibernate.TIMESTAMP, new Class[]{Timestamp.class}, new String[]{"TIMESTAMP", "STAMP"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Timestamp.class, Date.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("TIMESTAMP result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("TIMESTAMP result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.TIMESTAMP);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("TIMESTAMP parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Timestamp) {
                    query.setTimestamp(paramName, (Date)((Timestamp)inputValue));
                } else if (inputValue instanceof Date) {
                    query.setTimestamp(paramName, (Date)inputValue);
                } else {
                    throw new RuntimeException("Incorrect timestamp " + inputValue);
                }
            }
        }
    }
    ,
    BOOLEAN((Type)Hibernate.BOOLEAN, new Class[]{Boolean.class, Boolean.TYPE}, new String[]{"BOOLEAN", "BOOL"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Boolean.TYPE, Boolean.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BOOLEAN result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("BOOLEAN result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.BOOLEAN);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("BOOLEAN parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                query.setBoolean(paramName, ((Boolean)inputValue).booleanValue());
            }
        }
    }
    ,
    FLOAT((Type)Hibernate.FLOAT, new Class[]{Float.class, Float.TYPE}, new String[]{"FLOAT"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Float.TYPE, Float.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("FLOAT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("FLOAT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.FLOAT);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("FLOAT parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.FLOAT);
                } else {
                    query.setFloat(paramName, ((Float)inputValue).floatValue());
                }
            }
        }
    }
    ,
    DOUBLE((Type)Hibernate.DOUBLE, new Class[]{Double.class, Double.TYPE}, new String[]{"DOUBLE"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, Double.TYPE, Double.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DOUBLE result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("DOUBLE result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.DOUBLE);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("DOUBLE parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.DOUBLE);
                } else {
                    query.setDouble(paramName, ((Double)inputValue).doubleValue());
                }
            }
        }
    }
    ,
    BIG_INTEGER((Type)Hibernate.BIG_INTEGER, new Class[]{BigInteger.class}, new String[]{"BIGINT", "BIGINTEGER"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, BigInteger.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BIG_INTEGER result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("BIG_INTEGER result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.BIG_INTEGER);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("BIG_INTEGER parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.BIG_INTEGER);
                } else {
                    query.setBigInteger(paramName, (BigInteger)inputValue);
                }
            }
        }
    }
    ,
    BIG_DECIMAL((Type)Hibernate.BIG_DECIMAL, new Class[]{BigDecimal.class}, new String[]{"BIGDEC", "BIGDECIMAL"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, BigDecimal.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BIG_DECIMAL result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("BIG_DECIMAL result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.BIG_DECIMAL);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("BIG_DECIMAL parameter " + paramName + " " + inputValue + " " + hibernateType);
                }
                if (inputValue instanceof Collection) {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray(), (Type)Hibernate.BIG_DECIMAL);
                } else {
                    query.setBigDecimal(paramName, (BigDecimal)inputValue);
                }
            }
        }
    }
    ,
    ENUM_STRING((Type)Hibernate.STRING, new Class[0], new String[]{"ENUMSTRING", "ESTRING"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getMethodIgnoreParameters(pojo.getClass(), SqlUtils.set(attributeName));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ENUM_STRING result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                Method mm = SqlUtils.getMethodValueToEnum(m.getParameterTypes()[0], String.class);
                if (mm != null) {
                    Object enumInstance = SqlUtils.invokeMethod(mm, null, resultValue);
                    SqlUtils.invokeMethod(m, pojo, enumInstance);
                }
            } else {
                this.logger.error("ENUM_STRING result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.STRING);
            } else if (!inputValue.getClass().isEnum()) {
                if (!(inputValue instanceof Collection)) {
                    throw new RuntimeException("Incorrect enumeration " + inputValue);
                }
                ArrayList<String> vals = new ArrayList<String>();
                for (Object val : (Collection)inputValue) {
                    if (!val.getClass().isEnum()) {
                        throw new RuntimeException("Incorrect enumeration in collection " + val);
                    }
                    Method m = SqlUtils.getMethodEnumToValue(val.getClass());
                    vals.add((String)SqlUtils.invokeMethod(m, val));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ENUM_STRING parameter " + paramName + " " + inputValue + " " + inputValue.getClass() + " " + hibernateType + " " + vals);
                }
                query.setParameterList(paramName, vals.toArray());
            } else {
                Method m = SqlUtils.getMethodEnumToValue(inputValue.getClass());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ENUM_STRING parameter " + paramName + " " + inputValue + " " + inputValue.getClass() + " " + hibernateType + " " + m);
                }
                if (m != null) {
                    query.setString(paramName, (String)SqlUtils.invokeMethod(m, inputValue));
                }
            }
        }
    }
    ,
    ENUM_INT((Type)Hibernate.INTEGER, new Class[0], new String[]{"EINTEGER", "EINT"}){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getMethodIgnoreParameters(pojo.getClass(), SqlUtils.set(attributeName));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ENUM_INT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                Method mm = SqlUtils.getMethodValueToEnum(m.getParameterTypes()[0], Integer.class);
                if (mm != null) {
                    Object enumInstance = SqlUtils.invokeMethod(mm, null, resultValue);
                    SqlUtils.invokeMethod(m, pojo, enumInstance);
                }
            } else {
                this.logger.error("ENUM_INT result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (inputValue == null) {
                query.setParameter(paramName, inputValue, (Type)Hibernate.INTEGER);
            } else if (!inputValue.getClass().isEnum()) {
                if (!(inputValue instanceof Collection)) {
                    throw new RuntimeException("Incorrect enumeration " + inputValue);
                }
                ArrayList<Integer> vals = new ArrayList<Integer>();
                for (Object val : (Collection)inputValue) {
                    if (!val.getClass().isEnum()) {
                        throw new RuntimeException("Incorrect enumeration in collection " + val);
                    }
                    Method m = SqlUtils.getMethodEnumToValue(val.getClass());
                    vals.add((Integer)SqlUtils.invokeMethod(m, val));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ENUM_INT parameter " + paramName + " " + inputValue + " " + inputValue.getClass() + " " + hibernateType + " " + vals);
                }
                query.setParameterList(paramName, vals.toArray());
            } else {
                Method m = SqlUtils.getMethodEnumToValue(inputValue.getClass());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ENUM_INT parameter " + paramName + " " + inputValue + " " + inputValue.getClass() + " " + hibernateType + " " + m);
                }
                if (m != null) {
                    query.setInteger(paramName, ((Integer)SqlUtils.invokeMethod(m, inputValue)).intValue());
                }
            }
        }
    }
    ,
    HIBERNATE(null, new Class[0], new String[0]){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            Method m = SqlUtils.getSetter(pojo, attributeName, hibernateType.getReturnedClass());
            if (m == null && hibernateType instanceof PrimitiveType) {
                m = SqlUtils.getSetter(pojo, attributeName, ((PrimitiveType)hibernateType).getPrimitiveClass());
            }
            if (m == null && hibernateType.getReturnedClass() == Date.class) {
                m = SqlUtils.getSetter(pojo, attributeName, Timestamp.class);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("HIBERNATE result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType + " " + m);
            }
            if (m != null) {
                SqlUtils.invokeMethod(m, pojo, resultValue);
            } else {
                this.logger.error("HIBERNATE result " + pojo + " " + attributeName + " " + resultValue + " " + hibernateType);
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("HIBERNATE parameter " + paramName + " " + inputValue + " " + hibernateType);
            }
            if (inputValue instanceof Collection) {
                query.setParameterList(paramName, ((Collection)inputValue).toArray(), hibernateType);
            } else {
                query.setParameter(paramName, inputValue, hibernateType);
            }
        }
    }
    ,
    DEFAULT(null, new Class[0], new String[0]){

        @Override
        public void setResult(Object pojo, String attributeName, Object resultValue, Type hibernateType) {
            try {
                Class<?> attributeType = SqlUtils.getFieldType(pojo.getClass(), attributeName);
                if (attributeType.isEnum()) {
                    Method m = SqlUtils.getMethodIgnoreParameters(pojo.getClass(), SqlUtils.set(attributeName));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ENUM result " + pojo + " " + attributeName + " " + resultValue + " " + (resultValue != null ? resultValue.getClass() : "") + " " + hibernateType + " " + m);
                    }
                    if (m != null) {
                        Method mm = SqlUtils.getMethodValueToEnum(m.getParameterTypes()[0]);
                        if (mm != null) {
                            if (resultValue != null && resultValue instanceof BigDecimal) {
                                resultValue = ((BigDecimal)resultValue).intValue();
                            }
                            Object enumInstance = SqlUtils.invokeMethod(mm, null, resultValue);
                            SqlUtils.invokeMethod(m, pojo, enumInstance);
                        }
                    } else {
                        this.logger.error("ENUM result " + pojo + " " + attributeName + " " + resultValue + " " + (resultValue != null ? resultValue.getClass() : "") + " " + hibernateType);
                    }
                } else {
                    Method m = SqlUtils.getSetter(pojo, attributeName, attributeType);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("DEFAULT result " + pojo + " " + attributeName + " " + resultValue + " " + (resultValue != null ? resultValue.getClass() : "") + " " + hibernateType + " " + m);
                    }
                    if (resultValue != null && resultValue instanceof BigDecimal) {
                        resultValue = 22.handleBigDecimal(attributeType, resultValue);
                    }
                    if (m != null) {
                        SqlUtils.invokeMethod(m, pojo, resultValue);
                    } else {
                        this.logger.error("DEFAULT result " + pojo + " " + attributeName + " " + resultValue + " " + (resultValue != null ? resultValue.getClass() : "") + " " + hibernateType);
                    }
                }
            }
            catch (RuntimeException e) {
                this.logger.error("DEFAULT/ENUM result " + pojo + " " + attributeName + " " + resultValue + " " + (resultValue != null ? resultValue.getClass() : "") + " " + hibernateType + " " + e.getMessage());
                throw e;
            }
        }

        @Override
        void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, Type hibernateType) {
            if (!(inputValue instanceof Collection)) {
                if (inputType.isEnum()) {
                    Method m = SqlUtils.getMethodEnumToValue(inputType);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ENUM parameter " + paramName + " " + inputValue + " " + inputValue.getClass() + " " + hibernateType + " " + m);
                    }
                    if (m != null) {
                        if (m.getReturnType() == Integer.class || m.getReturnType() == Integer.TYPE) {
                            query.setInteger(paramName, ((Integer)SqlUtils.invokeMethod(m, inputValue)).intValue());
                        } else {
                            query.setString(paramName, (String)SqlUtils.invokeMethod(m, inputValue));
                        }
                    }
                } else {
                    SqlMetaType type = (SqlMetaType)((Object)classToTypeMap.get(inputType));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("DEFAULT parameter " + paramName + " " + inputValue + " " + (inputValue != null ? inputValue.getClass() : "-") + " " + hibernateType + " " + (Object)((Object)type));
                    }
                    if (type != null) {
                        type.setParameter(query, paramName, inputValue, inputType, hibernateType);
                    }
                }
            } else {
                ArrayList<Object> vals = new ArrayList<Object>();
                boolean isEnum = false;
                for (Object val : (Collection)inputValue) {
                    if (!val.getClass().isEnum()) break;
                    isEnum = true;
                    Method m = SqlUtils.getMethodEnumToValue(val.getClass());
                    vals.add(SqlUtils.invokeMethod(m, val));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("DEFAULT collection parameter " + paramName + " " + inputValue + " " + inputValue.getClass() + " " + hibernateType + " " + vals);
                }
                if (isEnum) {
                    query.setParameterList(paramName, vals.toArray());
                } else {
                    query.setParameterList(paramName, ((Collection)inputValue).toArray());
                }
            }
        }
    };

    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Type hibernateType;
    private Class<?>[] classTypes;
    private String[] metaTypes;
    static Map<Class<?>, SqlMetaType> classToTypeMap;
    static Map<String, SqlMetaType> metaToTypeMap;

    static Object handleBigDecimal(Class<?> attributeType, Object resultValue) {
        if (resultValue == null || !(resultValue instanceof BigDecimal)) {
            return resultValue;
        }
        BigDecimal result = (BigDecimal)resultValue;
        if (attributeType == Byte.class || attributeType == Byte.TYPE) {
            return result.byteValue();
        }
        if (attributeType == Integer.class || attributeType == Integer.TYPE) {
            return result.intValue();
        }
        if (attributeType == Long.class || attributeType == Long.TYPE) {
            return result.longValue();
        }
        if (attributeType == Short.class || attributeType == Short.TYPE) {
            return result.shortValue();
        }
        return result;
    }

    Type getHibernateType() {
        return this.hibernateType;
    }

    private SqlMetaType(Type hibernateType, Class<?>[] classTypes, String[] metaTypes) {
        this.hibernateType = hibernateType;
        this.classTypes = classTypes;
        this.metaTypes = metaTypes;
    }

    abstract void setResult(Object var1, String var2, Object var3, Type var4);

    abstract void setParameter(Query var1, String var2, Object var3, Class<?> var4, Type var5);

    static {
        classToTypeMap = new HashMap();
        for (SqlMetaType value : SqlMetaType.values()) {
            for (Class<?> clazz : value.classTypes) {
                classToTypeMap.put(clazz, value);
            }
        }
        metaToTypeMap = new HashMap<String, SqlMetaType>();
        for (SqlMetaType value : SqlMetaType.values()) {
            for (String metaType : value.metaTypes) {
                metaToTypeMap.put(metaType, value);
            }
        }
    }
}

