/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlExtendedMonitor;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlStandardControl;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlQueryEngine
extends SqlEngine {
    public static final SqlOrder NO_ORDER = SqlOrder.getOrder();
    public static final SqlOrder ASC_ORDER = SqlOrder.getAscOrder(1);
    public static final SqlOrder DESC_ORDER = SqlOrder.getDescOrder(1);

    public SqlQueryEngine(String name, String statement, String mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, null, null, typeFactory, pluginFactory);
    }

    public SqlQueryEngine(String name, String statement, String mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, monitor, features, typeFactory, pluginFactory);
    }

    public SqlQueryEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, null, null, typeFactory, pluginFactory);
    }

    public SqlQueryEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory);
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, null, (SqlControl)null);
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)null);
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, SqlOrder order) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setOrder(order));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMoreResultClasses(moreResultClasses));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMoreResultClasses(moreResultClasses));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, int firstResult, int maxResults) throws SqlProcessorException, SqlRuntimeException {
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setMaxResults(maxResults).setFirstResult(firstResult));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int firstResult, int maxResults) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxResults(maxResults).setFirstResult(firstResult));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, int maxTimeout, int maxResults, int firstResult) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMaxTimeout(maxTimeout).setMaxResults(maxResults).setFirstResult(firstResult));
    }

    public <E> List<E> query(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, SqlOrder order, int maxTimeout, int maxResults, int firstResult, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.query(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMaxTimeout(maxTimeout).setMaxResults(maxResults).setFirstResult(firstResult).setMoreResultClasses(moreResultClasses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> query(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> query, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        List<E> result = null;
        try {
            List<E> list = result = this.monitor.runList(new SqlMonitor.Runner(){

                @Override
                public List<E> run() {
                    SqlProcessResult processResult = SqlQueryEngine.this.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, sqlControl);
                    String sql = SqlQueryEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlQueryEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) > 0) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    if (SqlEngine.getFetchSize(sqlControl) > 0) {
                        query.setFetchSize(SqlEngine.getFetchSize(sqlControl));
                    }
                    query.setOrdered(SqlEngine.getOrder(sqlControl) != null && SqlEngine.getOrder(sqlControl) != NO_ORDER);
                    processResult.setQueryParams(session, query);
                    final SqlMappingResult mappingResult = SqlMappingRule.merge(SqlQueryEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, SqlEngine.getMoreResultClasses(sqlControl), query);
                    if (SqlEngine.getFirstResult(sqlControl) > 0) {
                        query.setFirstResult(SqlEngine.getFirstResult(sqlControl));
                        query.setMaxResults(SqlEngine.getMaxResults(sqlControl));
                    } else if (SqlEngine.getMaxResults(sqlControl) > 0) {
                        query.setMaxResults(SqlEngine.getMaxResults(sqlControl));
                    }
                    if (SqlQueryEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlQueryEngine.this.monitor;
                        return monitorExt.runListSql(new SqlMonitor.Runner(){

                            @Override
                            public List<E> run() {
                                return SqlQueryEngine.this.query(query, mappingResult, resultClass, sqlControl);
                            }
                        }, resultClass);
                    }
                    return SqlQueryEngine.this.query(query, mappingResult, resultClass, sqlControl);
                }
            }, resultClass);
            return list;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< query, result=" + result);
            }
        }
    }

    private <E> List<E> query(SqlQuery query, SqlMappingResult mappingResult, Class<E> resultClass, SqlControl sqlControl) {
        List list = query.list(mappingResult.getRuntimeContext());
        ArrayList<Object> result = new ArrayList<Object>();
        Object resultInstance = null;
        Object[] resultValue = null;
        Map<String, Object> ids = mappingResult.getIds();
        for (Object resultRow : list) {
            String idsKey;
            Object[] objectArray;
            if (resultRow instanceof Object[]) {
                objectArray = (Object[])resultRow;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = resultRow;
            }
            resultValue = objectArray;
            boolean changedIdentity = true;
            if (ids != null && ids.containsKey(idsKey = SqlUtils.getIdsKey(resultValue, mappingResult.getMainIdentityIndex()))) {
                resultInstance = ids.get(idsKey);
                changedIdentity = false;
            }
            if (changedIdentity && (resultInstance = (Object)BeanUtils.getInstance(resultClass)) == null) {
                throw new SqlRuntimeException("There's problem to instantiate " + resultClass);
            }
            mappingResult.setQueryResultData(resultInstance, resultValue, ids, SqlQueryEngine.getMoreResultClasses(sqlControl));
            if (!changedIdentity) continue;
            result.add(resultInstance);
            if (ids == null) continue;
            idsKey = SqlUtils.getIdsKey(resultValue, mappingResult.getMainIdentityIndex());
            ids.put(idsKey, resultInstance);
        }
        return result;
    }

    public int queryCount(SqlSession session) throws SqlProcessorException, SqlRuntimeException {
        return this.queryCount(session, null, null);
    }

    public int queryCount(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.queryCount(session, dynamicInputValues, null);
    }

    public int queryCount(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.queryCount(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int queryCount(SqlSession session, Object dynamicInputValues, Object staticInputValues, SqlOrder order, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.queryCount(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryCount(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> queryCount, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlQueryEngine.this.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, sqlControl);
                    final SqlQuery queryCount = session.createSqlQuery(SqlQueryEngine.this.pluginFactory.getSqlCountPlugin().sqlCount(processResult.getSql()));
                    queryCount.setLogError(processResult.isLogError());
                    SqlQueryEngine.this.typeFactory.getDefaultType().addScalar(queryCount, "vysledek", Integer.class);
                    if (SqlEngine.getMaxTimeout(sqlControl) > 0) {
                        queryCount.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    queryCount.setOrdered(SqlEngine.getOrder(sqlControl) != null && SqlEngine.getOrder(sqlControl) != NO_ORDER);
                    processResult.setQueryParams(session, queryCount);
                    if (SqlQueryEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlQueryEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlQueryEngine.this.queryCount(queryCount, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlQueryEngine.this.queryCount(queryCount, processResult);
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< queryCount, count=" + count);
            }
        }
    }

    private Integer queryCount(SqlQuery queryCount, SqlProcessResult processResult) {
        return (Integer)queryCount.unique(processResult.getRuntimeContext());
    }

    public String getSql(Object dynamicInputValues, Object staticInputValues, SqlOrder order) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setOrder(order));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        String sql = null;
        try {
            String string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlQueryEngine.this.process(SqlMetaStatement.Type.QUERY, dynamicInputValues, sqlControl);
                    String sql = SqlQueryEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlQueryEngine.this.name, processResult.getSql().toString());
                    return sql;
                }
            }, String.class);
            return string;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

