/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.config.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.sqlproc.engine.config.SqlEngineConfiguration;

@XmlRootElement(name="sqlp-configuration")
public class XmlEngineConfiguration {
    @XmlElementWrapper(name="queries")
    private List<EngineUsage> queryEngines;
    @XmlElementWrapper(name="cruds")
    private List<EngineUsage> crudEngines;
    @XmlElementWrapper(name="procedures")
    private List<EngineUsage> procedureEngines;
    @XmlElementWrapper(name="dynamicQueries")
    private List<EngineSql> dynamicQueryEngines;
    @XmlElementWrapper(name="dynamicCruds")
    private List<EngineSql> dynamicCrudEngines;
    @XmlElementWrapper(name="dynamicProcedures")
    private List<EngineSql> dynamicProcedureEngines;
    @XmlElement
    private Boolean lazyInit;
    @XmlElement
    private Boolean asyncInit;
    @XmlElement
    private Integer initTreshold;
    @XmlElement
    private Boolean initInUsageOrder;
    @XmlElement
    private Boolean initClearUsage;

    public XmlEngineConfiguration() {
    }

    private void copyEng(ConcurrentHashMap<String, AtomicInteger> from, List<EngineUsage> to) {
        for (Map.Entry<String, AtomicInteger> e : from.entrySet()) {
            to.add(new EngineUsage(e.getKey(), e.getValue()));
        }
    }

    private void copyDyn(ConcurrentHashMap<String, String> from, List<EngineSql> to) {
        for (Map.Entry<String, String> e : from.entrySet()) {
            to.add(new EngineSql(e.getKey(), e.getValue()));
        }
    }

    public XmlEngineConfiguration(SqlEngineConfiguration config) {
        this.queryEngines = new ArrayList<EngineUsage>();
        this.copyEng(config.getQueryEngines(), this.queryEngines);
        this.crudEngines = new ArrayList<EngineUsage>();
        this.copyEng(config.getCrudEngines(), this.crudEngines);
        this.procedureEngines = new ArrayList<EngineUsage>();
        this.copyEng(config.getProcedureEngines(), this.procedureEngines);
        this.dynamicQueryEngines = new ArrayList<EngineSql>();
        this.copyDyn(config.getDynamicQueryEngines(), this.dynamicQueryEngines);
        this.dynamicCrudEngines = new ArrayList<EngineSql>();
        this.copyDyn(config.getDynamicCrudEngines(), this.dynamicCrudEngines);
        this.dynamicProcedureEngines = new ArrayList<EngineSql>();
        this.copyDyn(config.getDynamicProcedureEngines(), this.dynamicProcedureEngines);
        this.lazyInit = config.getLazyInit();
        this.asyncInit = config.getAsyncInit();
        this.initTreshold = config.getInitTreshold();
        this.initInUsageOrder = config.getInitInUsageOrder();
        this.initClearUsage = config.getInitClearUsage();
    }

    private ConcurrentHashMap<String, AtomicInteger> copyEng(List<EngineUsage> from) {
        ConcurrentHashMap<String, AtomicInteger> engines = new ConcurrentHashMap<String, AtomicInteger>();
        if (from == null) {
            return engines;
        }
        for (EngineUsage e : from) {
            engines.put(e.getName(), new AtomicInteger(e.getUsage()));
        }
        return engines;
    }

    private ConcurrentHashMap<String, String> copyDyn(List<EngineSql> from) {
        ConcurrentHashMap<String, String> engines = new ConcurrentHashMap<String, String>();
        if (from == null) {
            return engines;
        }
        for (EngineSql e : from) {
            engines.put(e.getName(), e.getSql());
        }
        return engines;
    }

    public ConcurrentHashMap<String, AtomicInteger> getQueryEngines() {
        return this.copyEng(this.queryEngines);
    }

    public ConcurrentHashMap<String, AtomicInteger> getCrudEngines() {
        return this.copyEng(this.crudEngines);
    }

    public ConcurrentHashMap<String, AtomicInteger> getProcedureEngines() {
        return this.copyEng(this.procedureEngines);
    }

    public ConcurrentHashMap<String, String> getDynamicQueryEngines() {
        return this.copyDyn(this.dynamicQueryEngines);
    }

    public ConcurrentHashMap<String, String> getDynamicCrudEngines() {
        return this.copyDyn(this.dynamicCrudEngines);
    }

    public ConcurrentHashMap<String, String> getDynamicProcedureEngines() {
        return this.copyDyn(this.dynamicProcedureEngines);
    }

    public Boolean getLazyInit() {
        return this.lazyInit;
    }

    public Boolean getAsyncInit() {
        return this.asyncInit;
    }

    public Integer getInitTreshold() {
        return this.initTreshold;
    }

    public Boolean getInitInUsageOrder() {
        return this.initInUsageOrder;
    }

    public Boolean getInitClearUsage() {
        return this.initClearUsage;
    }

    @XmlRootElement(name="sql")
    public static class EngineSql {
        @XmlElement
        private String name;
        @XmlAttribute
        private String sql;

        public EngineSql() {
        }

        public EngineSql(String name, String sql) {
            this.name = name;
            this.sql = sql;
        }

        public String getName() {
            return this.name;
        }

        public String getSql() {
            return this.sql;
        }
    }

    @XmlRootElement(name="usage")
    public static class EngineUsage {
        @XmlElement
        private String name;
        @XmlAttribute
        private int usage;

        public EngineUsage() {
        }

        public EngineUsage(String name, AtomicInteger usage) {
            this.name = name;
            this.usage = usage.get();
        }

        public String getName() {
            return this.name;
        }

        public int getUsage() {
            return this.usage;
        }
    }
}

